type lexbuf = Lexing.lexbuf
type lex_tables = Lexing.lex_tables

(* 
  The most general engine: it calls a given function to extract
  the next class from the lexbuf  -> slow;
  the function is responsible for advancing the cursors in the lexbuf
  and refilling it
*)
external engine_classify_fun: 
  (lexbuf -> int) 
  -> lex_tables -> int -> lexbuf -> int = "lex_engine_classify_fun"


(* 
  an engine for atmost 8bit encodings, such as ASCII or Latin-1 (ISO 8859-1);
  it works with an array [table] of classes; table.(i) is
  the class of the character encoded by the byte i

  the size of the table *must* >= 256
*)
external engine_8bit:
  (int array)
  -> lex_tables -> int -> lexbuf -> int = "lex_engine_8bit"

(*
  the same, with a compact representation of the table as a string;
  usable when there are 256 classes or less;
  the string [s] is related to [table] by:
   s.[i] := Char.chr table.(i)

  the length of the string *must* >= 256
*)
external engine_tiny_8bit:
  string
  -> lex_tables -> int -> lexbuf -> int = "lex_engine_tiny_8bit"

(*
  an engine for the UTF-8 encoding; the string encode a class table
  for the first code points (at most 256 classes for these code points); 
  for higher code points, a function is called to handle classification
*)
external engine_tiny_utf8:
  string -> (int -> int)
  -> lex_tables -> int -> lexbuf -> int = "lex_engine_tiny_utf8"
