/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include <boost/lexical_cast.hpp>

#include "DomElement.h"

#include "Wt/WTable"
#include "Wt/WTableCell"
#include "Wt/WTableRow"

using std::find;

namespace Wt {

WTableRow::WTableRow(WTable *table, int numCells)
  : table_(table),
    height_(0)
{ 
  expand(numCells);
}

WTableRow::~WTableRow()
{
  delete height_;
}

WTableRow::TableData::TableData()
  : cell(0),
    overSpanned(false)
{ }

void WTableRow::expand(int numCells)
{
  int cursize = cells_.size();

  for (int col = cursize; col < numCells; ++col) {
    cells_.push_back(TableData());
    cells_.back().cell = new WTableCell(this, col);
  }
}

void WTableRow::insertColumn(int column)
{
  cells_.insert(cells_.begin() + column, TableData());
  cells_[column].cell = new WTableCell(this, column);

  for (unsigned i = column; i < cells_.size(); ++i)
    cells_[i].cell->column_ = i;
}

void WTableRow::deleteColumn(int column)
{
  delete cells_[column].cell;
  cells_.erase(cells_.begin() + column);

  for (unsigned i = column; i < cells_.size(); ++i)
    cells_[i].cell->column_ = i;
}

int WTableRow::rowNum() const
{
  return find(table_->rows_.begin(), table_->rows_.end(), this)
    - table_->rows_.begin();
}

void WTableRow::setHeight(const WLength& height)
{
  if (!height_)
    height_ = new WLength(height);
  else
    *height_ = height;

  table_->repaintRow(this);
}

void WTableRow::setStyleClass(const WString& style)
{
  styleClass_ = style;

  table_->repaintRow(this);
}

WLength WTableRow::height() const
{
  return height_ ? *height_ : WLength();
}

void WTableRow::updateDom(DomElement& element, bool all)
{
  if (height_)
    element.setProperty(PropertyStyleHeight, height_->cssText());

  if (!all || !styleClass_.empty())
    element.setAttribute("class", styleClass_.toUTF8());
}

}
