/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include "Wt/WModelIndex"
#include "Wt/WAbstractItemModel"

namespace Wt {

WModelIndex::WModelIndex()
  : model_(0),
    row_(-1),
    column_(-1)
{ }

boost::any WModelIndex::data() const
{
  return model_->data(*this);
}

WModelIndex::WModelIndex(int row, int column, const WAbstractItemModel *model)
  : model_(model),
    row_(row),
    column_(column)
{ }

}
