/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include <boost/lexical_cast.hpp>

#include "Wt/WLabel"
#include "DomElement.h"
#include "Wt/WText"
#include "Wt/WImage"
#include "Wt/WFormWidget"

namespace Wt {

WLabel::WLabel(WContainerWidget *parent)
  : WInteractWidget(parent),
    buddy_(0),
    text_(0),
    image_(0),
    buddyChanged_(false)
{ }

WLabel::WLabel(const WString& text, WContainerWidget *parent)
  : WInteractWidget(parent),
    buddy_(0),
    image_(0),
    buddyChanged_(false)
{ 
  text_ = new WText(text);
  text_->setWordWrap(false);
  text_->setParent(this);
}

WLabel::WLabel(WImage *image, WContainerWidget *parent)
  : WInteractWidget(parent),
    buddy_(0),
    text_(0),
    buddyChanged_(false)
{ 
  image_ = image;
  image_->setParent(this);
}

WLabel::~WLabel()
{
  setBuddy((WFormWidget *) 0);
}

void WLabel::setBuddy(WFormWidget *buddy)
{
  if (buddy_)
    buddy_->setLabel(0);

  buddy_ = buddy;
  if (buddy_)
    buddy_->setLabel(this);

  buddyChanged_ = true;
  repaint(RepaintPropertyAttribute);
}

void WLabel::setText(const WString& text)
{
  if (!text_) {
    text_ = new WText(text, 0);
    text_->setWordWrap(false);
    text_->setParent(this);
  } else
    text_->setText(text);
}

const WString& WLabel::text() const
{
  static WString empty("");
  if (text_)
    return text_->text();
  else
    return empty;
}

void WLabel::setImage(WImage *image)
{
  if (image_)
    delete image_;
  image_ = image;
  image_->setParent(this);
}

void WLabel::updateDom(DomElement& element, bool all)
{
  if (all) {
    if (text_)
      element.addChild(((WWebWidget *)text_)->createDomElement());

    if (image_)
      element.addChild(((WWebWidget *)image_)->createDomElement());
  }

  if (buddyChanged_ || all) {
    if (buddy_)
      element.setAttribute("for", buddy_->formName());

    buddyChanged_ = false;
  }

  WInteractWidget::updateDom(element, all);
}

DomElementType WLabel::domElementType() const
{
  return DomElement_LABEL;
}

void WLabel::getDomChanges(std::vector<DomElement *>& result)
{
  WInteractWidget::getDomChanges(result);

  if (text_)
    ((WWebWidget *)text_)->getDomChanges(result);
  if (image_)
    ((WWebWidget *)image_)->getDomChanges(result);
}

}
