/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include "Wt/WCssStyleSheet"
#include "Wt/WCssDecorationStyle"

namespace Wt {

WCssRule::WCssRule(const std::string& selector)
  : selector_(selector)
{ }
WCssRule::~WCssRule()
{ }

WCssDecorationRule::WCssDecorationRule(const std::string& selector,
				       const WCssDecorationStyle& style)
  : WCssRule(selector),
    style_(style)
{ }

const std::string WCssDecorationRule::declarations()

{
  return style_.cssText();
}

WCssOtherRule::WCssOtherRule(const std::string& selector,
			     const WString& declarations)
  : WCssRule(selector),
    declarations_(declarations)
{ }

const std::string WCssOtherRule::declarations()
{
  return declarations_.toUTF8(); 
}

WCssStyleSheet::WCssStyleSheet()
  : rulesAdded_(0)
{ }

WCssStyleSheet::~WCssStyleSheet()
{
  for (unsigned i = 0; i < rules_.size(); ++i)
    delete rules_[i];
}

void WCssStyleSheet::addRule(WCssRule *rule, const std::string& ruleName)
{
  rules_.push_back(rule);
  if (!ruleName.empty())
    defined_.insert(ruleName);
  ++rulesAdded_;
}

void WCssStyleSheet::addRule(const std::string& selector,
			     const WCssDecorationStyle& style,
			     const std::string& ruleName)
{
  addRule(new WCssDecorationRule(selector, style), ruleName);
}

void WCssStyleSheet::addRule(const std::string& selector,
			     const WString& declarations,
			     const std::string& ruleName)
{
  addRule(new WCssOtherRule(selector, declarations), ruleName);
}

bool WCssStyleSheet::isDefined(const std::string& ruleName) const
{
  return defined_.find(ruleName) != defined_.end();
}

std::string WCssStyleSheet::cssText(bool all)
{
  std::string result;

  if (all)
    rulesAdded_ = rules_.size();

  for (unsigned i = rules_.size() - rulesAdded_; i < rules_.size(); ++i) {
    result += rules_[i]->selector() + " { "
      + rules_[i]->declarations() + " }\n";
  }

  rulesAdded_ = 0;

  return result;
}

} // namespace Wt
