/* This Java-applet is able to display statistics in a browser window
   It will connect to the machine it was loaded from and expects to find
   a wiplcInted program on that machine. The port number can be specified
   in the HTML file the applet is loaded from (see wiplJava.html).
   
   The applet will display totals and speeds for the computer it is
   connecting from. The speeds are both calculated during the last about
   7 seconds and about last minute.
   
   The program doesn't handle errors very well. Also a button to reset the
   statistics would be nice. And also it would be nice to modify the wiplcInetd
   program so that we can view statictics for other cards too. So please 
   write a better program and send it to me :-)
*/   
   
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
 
import java.net.*;
import java.io.*;

// This class has the low levet network communicatin and returns a on demand
// a SpeedInfo object describing the read information:
class SpeedRead {
  // To lowlevel server communication:
  PrintWriter out;   
  BufferedReader in; 
  Socket sock;       
  
  class SpeedInfo {    
    int Cols;          // Number of rows (counters) to display
    String[] ColNames; // What they are called
    long[] ColValues;  // Which values the counters have
    double Time;       // From what time the information is from
    
    public SpeedInfo Subtract(SpeedInfo tos) {
      SpeedInfo s=new SpeedInfo();
      s.Cols=Cols;
      s.ColValues=new long[Cols];
      for(int a=0; a<Cols; a++) 
        s.ColValues[a]=ColValues[a]-tos.ColValues[a];
      s.Time=Time-tos.Time; 
      if(s.Time<0.1) s.Time=1;
      return s;
    }
  }
  
  // Returns true on succes and false on error:
  boolean Init(String adr, int port) {
    try {
      sock=new Socket(adr,port);
      out=new PrintWriter(sock.getOutputStream(),true);
      in=new BufferedReader(new InputStreamReader(sock.getInputStream()));
    } catch(Exception e) {
      System.err.println("Could not connect to the server!");
      return false;
    }
    return true;
  }
  
  // This tries to close the connection:
  void Close() {
    try {
      out.print("quit\r\n");
      out.flush();  
      in.close(); out.close(); sock.close();
    } catch(Exception e) {}
  }
  
  // This reads from the server and returns null on error:
  SpeedInfo Read() {
    try {
      SpeedInfo si=new SpeedInfo();
    
      out.print("gos\r\n");
      out.flush();

      // Read the number of values:
      String s=in.readLine();
      if(!s.startsWith("000 Counters: ")) throw new Exception("Server reported: "+s);
    
      si.Cols=Integer.valueOf(s.substring(14)).intValue();
    
      // Read the time:
      s=in.readLine();
      if(!s.startsWith("000 Time: ")) throw new Exception("Server reported: "+s);    
      int split=s.indexOf(' ',10);
      si.Time=Double.valueOf(s.substring(10,split)).doubleValue()+
              Double.valueOf(s.substring(split+1)).doubleValue()/1000000.0;

      // And then read the rest of the colums:
      si.ColNames=new String[si.Cols];
      si.ColValues=new long[si.Cols];

      for(int a=0; a<si.Cols; a++) {
        s=in.readLine();    
        int split1=s.indexOf(':');
        int split2=s.indexOf(':',split1+2);
        si.ColNames[a]=s.substring(4,split1);
      
        si.ColValues[a]=
          (Long.valueOf(s.substring(split1+2,split2)).longValue()<<32)+
          Long.valueOf(s.substring(split2+1)).longValue();
      }
    
      return si;
    } catch(Exception ex) {
      System.err.println("Error: "+ex.getMessage());
      return null;
    }
  }    
}    

// This one is used to calculate speeds
class CalculateSpeed {
  SpeedRead.SpeedInfo[] Buffer;
  int lastelem; // Index of the last element we put to the buffer
  int len;      // Number of stored elements
  int buflen;
  
  // Inits with a ringbuffer of size bufsize used when calculation the speeds:
  public CalculateSpeed(int bufsize) {
    Buffer=new SpeedRead.SpeedInfo[bufsize];
    lastelem=-1;
    len=0;
    buflen=bufsize;
  }
        
  synchronized public void Consume(SpeedRead.SpeedInfo s) {
    if(len<buflen) len++;
    if(++lastelem==buflen) lastelem=0;
    Buffer[lastelem]=s;
  }
  
  // 0=Don't look back, 1=Look at previoues
  synchronized public SpeedRead.SpeedInfo GetSpeeds(int lookback) { 
    if(len==0) throw new Error("Internal program error");
    if(lookback>=len) lookback=len-1;      
    int firstelem=lastelem-lookback;
    if(firstelem<0) firstelem+=buflen;
    
    // Now we should return difference between lastelem and firstelem
    return Buffer[lastelem].Subtract(Buffer[firstelem]);
  }
}

// The popup-frame with information:
class StatWindow extends Frame implements Runnable {
  private Thread StatUpdate; // The thread to update statistics  
  private SpeedRead toRead;  // Object that reads the statictics

  private Label[] total; 
  private Label[] speed1;
  private Label[] speed2;
  
  private SpeedRead.SpeedInfo start;
  private CalculateSpeed speed;
  
  StatWindow() { 
    super("Statictics");
    toRead=new SpeedRead();
    speed=new CalculateSpeed(19);
  };
  
  // Returns true on succes:
  synchronized public boolean start(String host, int port) {
    // Try to connect to the server on read the start data:
    if(!toRead.Init(host,port) ||
       (start=toRead.Read())==null) {
      // On error:
      dispose();
      return false;
    }
        
    GridLayout gl=new GridLayout(start.Cols,4);
    setLayout(gl);
    
    total=new Label[start.Cols];
    speed1=new Label[start.Cols];
    speed2=new Label[start.Cols];
    for(int a=0; a<start.Cols; a++) {
      add(new Label(start.ColNames[a],Label.LEFT)); 
      total[a]=new Label("00000000K",Label.RIGHT); add(total[a]);
      speed1[a]=new Label("000000KBS",Label.RIGHT); add(speed1[a]);
      speed2[a]=new Label("000000KBS",Label.RIGHT); add(speed2[a]);
    }
    
    pack();
    move(50,50);     
    setVisible(true);   

    StatUpdate=new Thread(this,"StatUpdate");
    StatUpdate.start();
    
    return true;
  }
  
  synchronized public boolean handleEvent(Event event) {
    if(event.id==Event.WINDOW_DESTROY) close();
    return super.handleEvent(event);
  }

  synchronized public void close() {
    if(StatUpdate==null) return;
    StatUpdate=null;
    notify(); 
  }
  
  public String print(double l) {
    int num=(int)(l*10);
    return (num/10)+"."+(num%10);
  }      
          
  synchronized public void run() {
    while(StatUpdate!=null) {
      SpeedRead.SpeedInfo totali=toRead.Read();	  	  	  
      if(totali==null) break; // On error with the connection:
      
      speed.Consume(totali);	  
      totali=totali.Subtract(start);
	  
      SpeedRead.SpeedInfo Speed1=speed.GetSpeeds(2);
      SpeedRead.SpeedInfo Speed2=speed.GetSpeeds(18);
	  
      for(int a=0; a<start.Cols; a++) {
        total[a].setText((totali.ColValues[a]>>10)+"K");
	    	    
        double spd1=Speed1.ColValues[a]/(1024.0*Speed1.Time);
	double spd2=Speed2.ColValues[a]/(1024.0*Speed2.Time);
	    
	speed1[a].setText(print(spd1)+"KBS");
	speed2[a].setText(print(spd2)+"KBS");
      }
      
      try {
        wait(3333);	
      } catch(InterruptedException e) { 
        break; 
      }
    }
    StatUpdate=null;
    dispose(); 
    toRead.Close();
  }
}

public class wiplJava extends Applet {
  Button b;
  Vector Childs;
  
  public void init() {
    b=new Button("Open statistic window");
    Childs=new Vector();
    add(b);
    validate();
  }
  
  public void destroy() {
    for(Enumeration e=Childs.elements(); e.hasMoreElements();) {
      ((StatWindow)e.nextElement()).close();
    }
  }

  public boolean action(Event e, Object o) {
    if(e.target==b) {
      int port=1000; // Default port
      try {
        port=Integer.parseInt(getParameter("port"));
      } catch(Exception ex) {}
      
      StatWindow s=new StatWindow();      
      if(s.start(getDocumentBase().getHost(),port)) Childs.addElement(s);
       
      return true;	
    }
    return false;
  }
}
