#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys
from winswitch.client.client_wrapper import parse_args
from winswitch.util.simple_logger import set_log_filename, set_log_dir
from winswitch.util.paths import CLIENT_DIR, APPLET_LOG

def main():
	set_log_dir(CLIENT_DIR)
	set_log_filename(APPLET_LOG)
	if not parse_args():
		return
	from winswitch.client.applet import main
	code = main()
	sys.exit(code)

if __name__ == "__main__":
	main()
