/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.tools.ReorderDialog;

public class ReorderTool
extends ObjectConstructor {
    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        ConstructionObject constructionObject = zirkelCanvas.selectObject(mouseEvent.getX(), mouseEvent.getY());
        if (constructionObject == null) {
            return;
        }
        ReorderDialog reorderDialog = new ReorderDialog(zirkelCanvas, constructionObject);
        if (!reorderDialog.isAborted()) {
            String string = reorderDialog.getResult();
            if (!string.equals("")) {
                ConstructionObject constructionObject2 = zirkelCanvas.getConstruction().find(string);
                if (constructionObject2 == null) {
                    zirkelCanvas.warning(Zirkel.name("reorder.notfound"));
                    return;
                }
                if (!zirkelCanvas.getConstruction().reorder(constructionObject, constructionObject2)) {
                    zirkelCanvas.warning(Zirkel.name("reorder.warning"));
                }
            } else if (!zirkelCanvas.getConstruction().reorder(constructionObject, null)) {
                zirkelCanvas.warning(Zirkel.name("reorder.warning"));
            }
        }
        zirkelCanvas.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateObjects(mouseEvent.getX(), mouseEvent.getY());
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.reorder", "Reorder: Select an object!"));
    }

    public boolean useSmartBoard() {
        return false;
    }
}

