/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.freehep.util.io.NoCloseInputStream;

public class XMLSequence
extends InputStream {
    private int[] xml = new int[]{60, 63, 120, 109, 108};
    private int xmlIndex;
    private int[] buffer = new int[this.xml.length];
    private int index;
    private boolean bufferEmpty;
    private InputStream in;
    private boolean closed;
    private boolean eof;

    public XMLSequence(InputStream inputStream) {
        this.in = inputStream;
        this.closed = false;
        this.eof = false;
        this.xmlIndex = 0;
        this.index = 0;
        this.bufferEmpty = true;
    }

    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        try {
            return this.readUntilXMLDeclaration();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public InputStream next() throws IOException {
        if (this.eof) {
            throw new NoSuchElementException(this.getClass() + ": at EOF.");
        }
        if (this.closed) {
            throw new NoSuchElementException(this.getClass() + ": already closed.");
        }
        if (!this.readUntilXMLDeclaration()) {
            throw new NoSuchElementException(this.getClass() + ": No more sequences.");
        }
        this.xmlIndex = 0;
        return new NoCloseInputStream(this);
    }

    public int read() throws IOException {
        int n2;
        if (this.xmlIndex == this.xml.length) {
            return -1;
        }
        if (this.closed) {
            return -1;
        }
        int n3 = -1;
        if (!this.eof) {
            if (this.bufferEmpty) {
                this.index = 0;
                for (n2 = 0; n2 < this.xml.length; ++n2) {
                    int n4;
                    this.buffer[n2] = n4 = this.in.read();
                    if (this.buffer[n2] == this.xml[this.xmlIndex]) {
                        ++this.xmlIndex;
                        continue;
                    }
                    if (this.xmlIndex > 0) {
                        ++this.xmlIndex;
                        continue;
                    }
                    this.xmlIndex = 0;
                }
                this.bufferEmpty = false;
                if (this.xmlIndex == this.xml.length) {
                    return -1;
                }
            }
            if ((n3 = this.in.read()) != -1) {
                this.xmlIndex = n3 == this.xml[this.xmlIndex] ? ++this.xmlIndex : 0;
            } else {
                this.eof = true;
            }
        }
        if (this.eof && this.buffer[this.index] == -1) {
            return -1;
        }
        n2 = this.buffer[this.index];
        this.buffer[this.index] = n3;
        this.index = (this.index + 1) % this.buffer.length;
        return n2;
    }

    public void mark(int n2) {
        this.in.mark(n2);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.getClass() + ": already closed.");
        }
        if (!this.in.markSupported()) {
            throw new IOException(this.getClass() + ": does not support reset().");
        }
        this.in.reset();
        this.xmlIndex = 0;
        this.index = 0;
        this.bufferEmpty = true;
        this.eof = false;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    private boolean readUntilXMLDeclaration() throws IOException {
        while (this.read() >= 0) {
        }
        return this.xmlIndex == this.xml.length;
    }
}

