/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphics2d.font.Lookup;

public class FontUtilities {
    private static final Properties windowsFonts = new Properties();
    private static final CharTable[] STANDARD_CHAR_TABLES;
    private static final Font[] STANDARD_FONT;

    private FontUtilities() {
    }

    public static List getAllAvailableFonts() {
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public static String getWindowsFontName(String string) {
        return windowsFonts.getProperty(string, string);
    }

    public static String getEncodedString(String string, String string2) {
        return FontEncoder.getEncodedString(string, string2);
    }

    public static String getEncodedString(String string, CharTable charTable) {
        return FontEncoder.getEncodedString(string, charTable);
    }

    public static void showString(Font font, String string, CharTable charTable, ShowString showString) throws IOException {
        if (charTable == null) {
            throw new RuntimeException("FontUtilities.showString(...): latinTable cannot be 'null'");
        }
        FontUtilities.STANDARD_FONT[0] = font;
        FontUtilities.STANDARD_FONT[1] = new Font("Symbol", 0, font.getSize());
        FontUtilities.STANDARD_FONT[2] = new Font("ZapfDingbats", 0, font.getSize());
        FontUtilities.STANDARD_CHAR_TABLES[0] = charTable;
        char[] cArray = string.toCharArray();
        String string2 = "";
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int n3 = n2;
            char c2 = (char)STANDARD_CHAR_TABLES[n3].toEncoding(cArray[i2]);
            if (c2 == '\u0000') {
                n3 = -1;
                do {
                    if (++n3 == n2) continue;
                    c2 = (char)STANDARD_CHAR_TABLES[n3].toEncoding(cArray[i2]);
                } while (c2 == '\u0000' && n3 < STANDARD_CHAR_TABLES.length - 1);
            }
            if (c2 == '\u0000') {
                n3 = n2;
            }
            if (n3 != n2 && !string2.equals("")) {
                showString.showString(STANDARD_FONT[n2], string2);
                string2 = "";
            }
            string2 = string2 + c2;
            n2 = n3;
        }
        showString.showString(STANDARD_FONT[n2], string2);
    }

    static {
        String string = "Arial";
        windowsFonts.setProperty("Dialog", string);
        windowsFonts.setProperty("DialogInput", "Courier New");
        windowsFonts.setProperty("Serif", "Times New Roman");
        windowsFonts.setProperty("SansSerif", string);
        windowsFonts.setProperty("Monospaced", "Courier New");
        windowsFonts.setProperty("Courier", "Courier New");
        windowsFonts.setProperty("Helvetica", string);
        windowsFonts.setProperty("Times-Roman", "Times New Roman");
        windowsFonts.setProperty("TimesRoman", "Times New Roman");
        windowsFonts.setProperty("Times", "Times New Roman");
        windowsFonts.setProperty("Symbol", "Arial Unicode MS");
        windowsFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
        STANDARD_CHAR_TABLES = new CharTable[]{null, Lookup.getInstance().getTable("Symbol"), Lookup.getInstance().getTable("Zapfdingbats")};
        STANDARD_FONT = new Font[]{null, new Font("Symbol", 0, 10), new Font("ZapfDingbats", 0, 10)};
    }

    public static interface ShowString {
        public void showString(Font var1, String var2) throws IOException;
    }
}

