/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.functions.FunctionParserExtension;

public class ExpressionFunction
extends FunctionParserExtension {
    private Expression definition;
    private Variable[] params;

    public ExpressionFunction(String string, String string2) {
        this(string, new String[]{"x"}, string2, null);
    }

    public ExpressionFunction(String string, String[] stringArray, String string2, Parser parser) {
        this.setName(string);
        if (stringArray == null) {
            this.params = new Variable[0];
        } else {
            this.params = new Variable[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.params[i] = new Variable(stringArray[i]);
            }
        }
        this.redefine(string2, parser);
        if (parser != null && string != null) {
            parser.add(this);
        }
    }

    public ExpressionFunction(String string, Variable[] variableArray, Expression expression) {
        this.setName(string);
        this.params = variableArray == null ? new Variable[]{} : variableArray;
        this.definition = expression;
    }

    private ExpressionFunction() {
    }

    public void redefine(String string) {
        this.redefine(string, null);
    }

    public void redefine(String string, Parser parser) {
        parser = parser == null ? new Parser() : new Parser(parser);
        for (int i = 0; i < this.params.length; ++i) {
            parser.add(this.params[i]);
        }
        this.definition = parser.parse(string);
    }

    public String getDefinitionString() {
        return ((Object)this.definition).toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name == null ? "unnamed function of (" : "function " + this.name + "(");
        for (int i = 0; i < this.params.length; ++i) {
            stringBuffer.append(this.params[i].getName());
            if (i >= this.params.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") given by ");
        stringBuffer.append(((Object)this.definition).toString());
        return stringBuffer.toString();
    }

    @Override
    public int getArity() {
        return this.params.length;
    }

    @Override
    public double getVal(double[] dArray) {
        return this.getValueWithCases(dArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValueWithCases(double[] dArray, Cases cases) {
        Variable[] variableArray = this.params;
        synchronized (this.params) {
            if (dArray == null) {
                if (this.params.length > 0) {
                    throw new IllegalArgumentException("Internal Error:  Number of arguments provided to function does not match its arity.");
                }
            } else {
                if (dArray.length != this.params.length) {
                    throw new IllegalArgumentException("Internal Error:  Number of arguments provided to function does not match its arity.");
                }
                for (int i = 0; i < this.params.length; ++i) {
                    this.params[i].setVal(dArray[i]);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.definition.getValueWithCases(cases);
        }
    }

    @Override
    public Function derivative(int n) {
        if (n <= 0 || n > this.getArity()) {
            throw new IllegalArgumentException("Internal Error:  Attempt to take the derivative of a function of " + this.getArity() + " variables with respect to argument number " + n + ".");
        }
        ExpressionFunction expressionFunction = new ExpressionFunction();
        if (this.name != null) {
            if (this.getArity() == 1) {
                expressionFunction.setName(this.getName() + "'");
            } else {
                expressionFunction.setName("D" + n + "[" + this.getName() + "]");
            }
        }
        expressionFunction.params = this.params;
        expressionFunction.definition = this.definition.derivative(this.params[n - 1]);
        return expressionFunction;
    }

    @Override
    public Function derivative(Variable variable) {
        ExpressionFunction expressionFunction = new ExpressionFunction();
        if (this.name != null) {
            expressionFunction.setName("D" + variable.getName() + "[" + this.getName() + "]");
        }
        expressionFunction.params = this.params;
        expressionFunction.definition = this.definition.derivative(variable);
        return expressionFunction;
    }

    @Override
    public boolean dependsOn(Variable variable) {
        return this.definition.dependsOn(variable);
    }

    @Override
    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        for (int i = this.getArity() - 1; i >= 0; --i) {
            this.params[i].setVal(stackOfDouble.pop());
        }
        stackOfDouble.push(this.definition.getValueWithCases(cases));
    }
}

