/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;

class Model3D {
    float[] vert;
    int[] tvert;
    int nvert;
    int maxvert;
    int[] con;
    int ncon;
    int maxcon;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    static Color[] gr;

    Model3D() {
        this.mat.xrot(20.0);
        this.mat.yrot(30.0);
    }

    Model3D(InputStream inputStream) throws IOException, FileFormatException {
        this();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream)));
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        block4: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break block4;
                }
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("v".equals(streamTokenizer.sval)) {
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        if (streamTokenizer.nextToken() == -2) {
                            d = streamTokenizer.nval;
                            if (streamTokenizer.nextToken() == -2) {
                                d2 = streamTokenizer.nval;
                                if (streamTokenizer.nextToken() == -2) {
                                    d3 = streamTokenizer.nval;
                                }
                            }
                        }
                        this.addVert((float)d, (float)d2, (float)d3);
                        while (true) {
                            if (streamTokenizer.ttype == 10 || streamTokenizer.ttype == -1) continue block4;
                            streamTokenizer.nextToken();
                        }
                    }
                    if ("f".equals(streamTokenizer.sval) || "fo".equals(streamTokenizer.sval) || "l".equals(streamTokenizer.sval)) {
                        int n = -1;
                        int n2 = -1;
                        int n3 = -1;
                        while (true) {
                            if (streamTokenizer.nextToken() == -2) {
                                n3 = (int)streamTokenizer.nval;
                                if (n2 >= 0) {
                                    this.add(n2 - 1, n3 - 1);
                                }
                                if (n < 0) {
                                    n = n3;
                                }
                                n2 = n3;
                                continue;
                            }
                            if (streamTokenizer.ttype != 47) break;
                            streamTokenizer.nextToken();
                        }
                        if (n >= 0) {
                            this.add(n - 1, n2 - 1);
                        }
                        if (streamTokenizer.ttype == 10) continue block4;
                        break block4;
                    }
                    while (streamTokenizer.nextToken() != 10 && streamTokenizer.ttype != -1) {
                    }
                    continue block4;
                }
            }
            break;
        }
        inputStream.close();
        if (streamTokenizer.ttype != -1) {
            throw new FileFormatException(streamTokenizer.toString());
        }
    }

    int addVert(float f, float f2, float f3) {
        int n = this.nvert;
        if (n >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
            } else {
                this.maxvert *= 2;
                float[] fArray = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, fArray, 0, this.vert.length);
                this.vert = fArray;
            }
        }
        this.vert[n *= 3] = f;
        this.vert[n + 1] = f2;
        this.vert[n + 2] = f3;
        return this.nvert++;
    }

    void add(int n, int n2) {
        int n3 = this.ncon;
        if (n >= this.nvert || n2 >= this.nvert) {
            return;
        }
        if (n3 >= this.maxcon) {
            if (this.con == null) {
                this.maxcon = 100;
                this.con = new int[this.maxcon];
            } else {
                this.maxcon *= 2;
                int[] nArray = new int[this.maxcon];
                System.arraycopy(this.con, 0, nArray, 0, this.con.length);
                this.con = nArray;
            }
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        this.con[n3] = n << 16 | n2;
        this.ncon = n3 + 1;
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(int[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var1_1[(var2_2 + var3_3) / 2];
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var1_1[var4_4] < var6_6) continue block0;
                    while (var5_5 > var2_2 && var1_1[var5_5] > var6_6) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    void compress() {
        int n = this.ncon;
        int[] nArray = this.con;
        this.quickSort(this.con, 0, this.ncon - 1);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[n4];
            if (n3 != n5) {
                nArray[n2] = n5;
                ++n2;
            }
            n3 = n5;
            ++n4;
        }
        this.ncon = n2;
    }

    void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        if (gr == null) {
            gr = new Color[16];
            n2 = 0;
            while (n2 < 16) {
                n = (int)(170.0 * (1.0 - Math.pow((double)n2 / 15.0, 2.3)));
                Model3D.gr[n2] = new Color(n, n, n);
                ++n2;
            }
        }
        n2 = 0;
        n = this.ncon;
        int[] nArray = this.con;
        int[] nArray2 = this.tvert;
        if (n <= 0 || this.nvert <= 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = (n4 >> 16 & 0xFFFF) * 3;
            int n6 = (n4 & 0xFFFF) * 3;
            int n7 = nArray2[n5 + 2] + nArray2[n6 + 2];
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 > 15) {
                n7 = 15;
            }
            if (n7 != n2) {
                n2 = n7;
                graphics.setColor(gr[n7]);
            }
            graphics.drawLine(nArray2[n5], nArray2[n5 + 1], nArray2[n6], nArray2[n6 + 1]);
            ++n3;
        }
    }

    void findBB() {
        float f;
        float f2;
        float f3;
        if (this.nvert <= 0) {
            return;
        }
        float[] fArray = this.vert;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this.nvert * 3;
        while ((n -= 3) > 0) {
            float f7;
            float f8;
            float f9 = fArray[n];
            if (f9 < f3) {
                f3 = f9;
            }
            if (f9 > f4) {
                f4 = f9;
            }
            if ((f8 = fArray[n + 1]) < f2) {
                f2 = f8;
            }
            if (f8 > f5) {
                f5 = f8;
            }
            if ((f7 = fArray[n + 2]) < f) {
                f = f7;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        this.xmax = f4;
        this.xmin = f3;
        this.ymax = f5;
        this.ymin = f2;
        this.zmax = f6;
        this.zmin = f;
    }
}

