
package maths;

/**
 * Cette classe implemente la difference symmetrique de deux ensembles.
 * 
 * @author Nicolae
 */
public class SymmDiff extends DefaultSet {

	private Set A;
	private Set B;
	
	/**
	 * Cache le constructor standard.
	 */
	private SymmDiff() {}
	
	
	/**
	 * Constructor qui initialise les deux ensembles.
	 *
	 * @param A ensemble.
	 * @param B ensemble.
	 */
	public SymmDiff(Set A, Set B) {
		this.A = A;
		this.B = B;
	}
	
	public boolean contains(double re, double im) {
		return A.contains(re, im) ^ B.contains(re, im);
	}
}
