/*
 * Copyright (C) 2002-4 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __S__EDITOR_MAIN_MENU_MAP_OPTIONS_H
#define __S__EDITOR_MAIN_MENU_MAP_OPTIONS_H

#include "map.h"
#include "ui_window.h"
#include "ui_textarea.h"
#include "ui_multilineeditbox.h"
#include "ui_editbox.h"


class Editor_Interactive;

/*
=================================================

class Main_Menu_Map_Options

this is the Main Options Menu. Here, informations
about the current map are displayed and you can change
author, name and description

=================================================
*/
class Main_Menu_Map_Options : public UIWindow {
   public:
      Main_Menu_Map_Options(Editor_Interactive*);
      virtual ~Main_Menu_Map_Options();

   private:
      void changed(int);
      void editbox_changed(void);
      Editor_Interactive  *m_parent;
      UIMultiline_Editbox* m_descr;
      UITextarea* m_world, *m_nrplayers, *m_size;
      UIEdit_Box* m_name, *m_author;
      void update();
};

#endif

