/*
 * Copyright (C) 2002-4 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <map>
#include "event.h"
#include "event_referencer.h"
#include "map.h"
#include "editor_game_base.h"
#include "game.h"

/*
 * reference or unrefereence this Event
 */
void Event::reference( EventReferencer* ref ) {
   m_referencers[ ref ] ++;
}
void Event::unreference( EventReferencer* ref) {
   std::map<EventReferencer*, uint>::iterator cur = m_referencers.find( ref );
   if( cur != m_referencers.end() ) {
      cur->second--;
      if( cur->second == 0)
         m_referencers.erase( cur );
   }
}
