/*
 * NodeMultitexture.h
 *
 * Copyright (C) 1999 Stephen F. White, 2006 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_MULTI_TEXTURE_H
#define _NODE_MULTI_TEXTURE_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoMultiTexture : public Proto {
public:
                    ProtoMultiTexture(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return X3D_MULTI_TEXTURE; }
    virtual int     getNodeClass() const { return TEXTURE_NODE; }

    FieldIndex alpha;
    FieldIndex color;
    FieldIndex function;
    FieldIndex mode;
    FieldIndex source;
    FieldIndex texture;
};


class NodeMultiTexture : public Node {
public:
                    NodeMultiTexture(Scene *scene, Proto *proto);

    virtual const char* getComponentName(void) const { return "Texturing"; }
    virtual int         getComponentLevel(void) const { return 2; }
    virtual Node   *copy() const { return new NodeMultiTexture(*this); }

    void            bind();
    void            unbind();

    virtual bool    isInvalidChildNode(void) { return true; }

    virtual bool    isTransparent(void);
   
    virtual int     writeProto(int f) { return writeX3dProto(f); }

    fieldMacros(SFFloat,  alpha,    ProtoMultiTexture)
    fieldMacros(SFColor,  color,    ProtoMultiTexture)
    fieldMacros(MFString, function, ProtoMultiTexture)
    fieldMacros(MFString, mode,     ProtoMultiTexture)
    fieldMacros(MFString, source,   ProtoMultiTexture)
    fieldMacros(MFNode,   texture,  ProtoMultiTexture)
};

#endif // _NODE_MULTI_TEXTURE_H
