/*
 * Types.cpp
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 *
 * automatic (via configure) generated file, direct change is useless.
 * change batch/mkSFMFTypes.sh instead
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "Types.h"

#include "SFMFTypes.h"

FieldValue* defaultTypeArray[] = 
{
   new MFColor(),
   new MFFloat(),
   new MFInt32(),
   new MFNode(),
   new MFRotation(),
   new MFString(),
   new MFTime(),
   new MFVec2f(),
   new MFVec3f(),
   new SFBool(),
   new SFColor(),
   new SFFloat(),
   new SFImage(),
   new SFInt32(),
   new SFNode(),
   new SFRotation(),
   new SFString(),
   new SFTime(),
   new SFVec2f(),
   new SFVec3f(),
};

int
typeStringToEnum(const char* str)
{
   int len = sizeof(defaultTypeArray)/sizeof(FieldValue*);
   for (int i = 0; i < len; i++)
       if (strcmp(defaultTypeArray[i]->getTypeName(),str)==0)
           return defaultTypeArray[i]->getType();
   return -1;
}

const char* 
typeEnumToString(int type)
{
   int len = sizeof(defaultTypeArray)/sizeof(FieldValue*);
   for (int i = 0; i < len; i++)                                 
       if (defaultTypeArray[i]->getType() == type)
           return defaultTypeArray[i]->getTypeName();
   return NULL;
}

FieldValue *typeDefaultValue(int type)
{
   int len = sizeof(defaultTypeArray)/sizeof(FieldValue*);
   for (int i = 0; i < len; i++)                                 
       if (defaultTypeArray[i]->getType() == type)
           return defaultTypeArray[i]->copy();

   // unknown type used ?
   assert(false);
   return NULL;
}

int getSFType(int type) 
{
   switch(type) {
     case MFCOLOR:
       return SFCOLOR;
     case MFFLOAT:
       return SFFLOAT;
     case MFINT32:
       return SFINT32;
     case MFNODE:
       return SFNODE;
     case MFROTATION:
       return SFROTATION;
     case MFSTRING:
       return SFSTRING;
     case MFTIME:
       return SFTIME;
     case MFVEC2F:
       return SFVEC2F;
     case MFVEC3F:
       return SFVEC3F;
   }   
   return type;
}

bool isMFType(int type) 
{
   switch(type) {
     case MFCOLOR:
       return true;
     case MFFLOAT:
       return true;
     case MFINT32:
       return true;
     case MFNODE:
       return true;
     case MFROTATION:
       return true;
     case MFSTRING:
       return true;
     case MFTIME:
       return true;
     case MFVEC2F:
       return true;
     case MFVEC3F:
       return true;
   }   
   return false;
}
