/*
 * MFInt32.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "MFInt32.h"
#include "SFInt32.h"
#include "DuneApp.h"

MFInt32::MFInt32()
{
    _value.resize(0);
}

MFInt32::MFInt32(int *values, int len)
{
    _value.setData(values, len);
}

MFInt32::MFInt32(const MFInt32 &value)
{
    _value.setData(value.getValues(), value.getSize());
}

MFInt32::MFInt32(const int value)
{
    _value.resize(0);
    _value[0] = value;
}

MFInt32::~MFInt32()
{
    _value.resize(0);
}

FieldValue *
MFInt32::copy()
{
    int *value = new int[_value.size()];
    for (int i = 0;i < _value.size(); i++)
        value[i] = _value[i];
    return new MFInt32(value, _value.size());
}

int MFInt32::write(int f, int indent) const
{
    /* search for -1 values */
    bool noMinus1=true;
    {
    for (int i = 0; i < _value.size(); i++)
        if (_value[i]==-1)
            noMinus1=false;
    }
    if (!TheApp->GetkrFormating()) {
        RET_ONERROR( mywritestr(f, "\n") )
        TheApp->incSelectionLinenumber();
        RET_ONERROR( indentf(f, indent + TheApp->GetIndent()) )
    }
    RET_ONERROR( mywritestr(f, "[\n") )
    TheApp->incSelectionLinenumber();
    /* write all values in one line till -1 */
    bool indentflag=noMinus1;
    {
    for (int i = 0; i < _value.size(); i++) {
        if (i==0) indentflag=true;
        if (indentflag) RET_ONERROR( indentf(f, indent + TheApp->GetIndent()) )
	RET_ONERROR( mywritef(f, "%d ", _value[i]) )
        indentflag=noMinus1;
        if (_value[i]==-1) indentflag=true;
        if (indentflag || (i == _value.size() - 1)) {
	   RET_ONERROR( mywritestr(f, "\n") )
           TheApp->incSelectionLinenumber();
        }
    }
    }
    if (!TheApp->GetkrFormating())
        RET_ONERROR( indentf(f, indent + TheApp->GetIndent()) )
    else
        RET_ONERROR( indentf(f, indent) )
    RET_ONERROR( mywritestr(f, "]\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}

bool
MFInt32::equals(const FieldValue *value) const
{
    if (value->getType() == MFINT32) {
	MFInt32		*v = (MFInt32 *) value;
	if (v->getSize() != _value.size()) return false;
	for (int i = 0; i < _value.size(); i++)
	    if (_value[i] != v->getValue(i))
		return false;
	return true;
    }
    return false;
}

FieldValue *
MFInt32::getSFValue(int index) const
{
    return new SFInt32(_value[index]);
}

void
MFInt32::setSFValue(int index, FieldValue *value)
{
    _value[index] = ((SFInt32 *) value)->getValue();
}

void
MFInt32::setSFValue(int index, int value)
{
    _value[index] = value;
}


MyString
MFInt32::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // array ([0] [1] [2] ...) of signed 32 bit integers (... -1, 0, 1, 2 ..)\n";
        ret += indent;
        ret += "   // integer range: about (-2147483647-1) to 2147483647\n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new MFInt32(int_i1, int_i2, ...);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // int_i = ";
            ret += name;
            ret += ".length();\n";

            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
       }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += " = new MFInt32(-1, 2, -3, 100);\n";

             ret += indent;
             ret += "   // ";
             ret += name;
             ret += "[0] = 42;\n";
        } 
        if (flags != EL_EVENT_OUT) {
             ret += indent;
             ret += "   // int_i =";
             ret += name;
             ret += "[0]\n";
        }
    }
    return ret;

}

void 
MFInt32::insertSFValue(int index, FieldValue *value)
{
    _value.insert(((SFInt32 *)value)->getValue(), index);
}

void 
MFInt32::insertSFValue(int index, int value)
{
    _value.insert(value, index);
}


