/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _TERMINAL_H
#define _TERMINAL_H

#include <wftk/multilineedit.h>

namespace wftk {

/// Terminal widget: has multi-line output, one-line input, scroll bar 
class Terminal : public MultiLineEdit
{
 public:

  /** Constructor.
   *
   * \param text Initial text for this Terminal.  Defaults to empty string.
   * \param font Initial font for this Terminal.  Defaults to wftk system font.
   * \param readonly boolean flag.  Allows / disallows direct text input into
   * the multi-line portion of the terminal.
   * \param fill boolean flag.  If true, Terminal will expand to fill available
   * space.
   */
  explicit Terminal(const std::string& text = "", const Font &font=Font(),
	bool readonly = true, bool fill = false);
  ///
  virtual ~Terminal();

  /// Scroll terminal up (equivalent to clicking up-arrow of scroll bar)
  void scrollUp(int);
  /// Scroll terminal down (equivalent to clicking down-arrow of scroll bar)
  void scrollDown(int);
  /// Scroll to arbitrary location (called when dragging slider of scroll bar)
  void scrollTo(int);
  /// Scroll terminal to the top
  void scroll2Top();
  /// Scroll terminal to the bottom
  void scroll2Bottom();
  /// Number of lines in this terminal
  unsigned linesCount() const;
  /// Current line 
  unsigned currentLine() const;
  /// Emitted when terminal is scrolled
  SigC::Signal0<void> scrolled;

 private:
  ///
  virtual void updateText();
  ///
  unsigned scrollTo_;
  ///
  unsigned currentLine_;
  ///
  unsigned allLines_;
};

}
#endif // _MULTILINEDIT_

