/*
 * WengoPhone, a voice over Internet phone
 * Copyright (C) 2004-2005  Wengo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef WEBCAM_EVENT_H
#define WEBCAM_EVENT_H

#include <stdint.h>

#include <qobject.h>
#include <qevent.h>

/**
 * @author David Ferlier
 *
 */

class WebcamEvent : public QCustomEvent
{
	public:
		enum Type { FrameReady = (QEvent::User + 200) };

		WebcamEvent(Type t, struct webcam *localWebcam, uint8_t *f, int w, int h) : QCustomEvent(t) {
			frame = f;
			width = w;
			height = h;
			cam = localWebcam;
		}

		~WebcamEvent() {}

		QString msg() { return text;}

		struct webcam *cam;
		uint8_t *frame;
		int width, height;

	private:
		QString text;
};


#endif
