#!/usr/bin/perl

$test="true";


use IMAP::Sieve;

sub opensieve {
	my ($uid,$pass,$port,$server,$ssl)=@_;
	if ($ssl) {
	$sieve=IMAP::Sieve->new('Server'=>$server,'Login'=>$uid,'Password'=>$pass,'Port'=>$port,'SSL'=>$ssl,'SSL_ca_file'=>'certs/ca-cert.pem');
	}
	else {
	$sieve=IMAP::Sieve->new('Server'=>$server,'Login'=>$uid,'Password'=>$pass,'Port'=>$port);
	}		
	return;
}
	
sub closesieve {
	 if ($sieve) {$sieve->close};
}

sub listscripts {
   	@scripts=$sieve->listscripts;
   	return (join("\n",@scripts)."\n") ;
}   	
   	
sub getscript {
	my ($script) = @_;
	my ($scriptfile);

	$scriptfile=$sieve->getscript($script);
	return $scriptfile;
}

sub putscript {
	my ($scriptname,$script) = @_;
	$res=$sieve->putscript($scriptname,$script);
	if ($res) {print $sieve->{'Error'}}
	return;
}
	
sub setactive {
	my ($script)=@_;
	$res=$sieve->setactive($script);
	if ($res) { print $sieve->{'Error'};}
	return;
}
	
sub noop {
	$test=$sieve->noop;
	return;
}

sub deletescript {
	my ($script)=@_;
	$res=$sieve->deletescript($script);
	if ($res) {print $sieve->{'Error'};}
	return;
}
	
sub readscript {
	open (IN,"./testscript");
	$script="";
	while (<IN>) {
		$script.=$_;
	}
}

$script="# this is a test script\n#test again\n";

if ($test) {
print "Please enter the user and password at the prompts\n";
print "Enter login name: ";
chomp($login = <>);
print "Enter password: ";
chomp($password = <>);
print "Enter the SSL port# for sieve: ";
chomp($port = <>);
print "Enter the sieve server hostname: ";
chomp($server = <>);
$ssl='1';
print "server=[$server],port=[$port],ssl=[$ssl]\n";
print "\n##opening connection\n";
&opensieve($login,$password,$port,$server,$ssl);
print $sieve->{'Error'}."\n";
print "Capability=$sieve->{'Capability'}\n";

print "\m##saving script\n";
&putscript('test1',$script);
print $sieve->{'Error'}."\n";

print "\n##listing scripts\n";
print &listscripts;

print "\n##getting script\n";
print &getscript('test1');
print $sieve->{'Error'}."\n";

print "\n##setting active script\n";
&setactive('testscript1');
print $sieve->{'Error'}."\n";

print "\n##listing scripts again\n";
print &listscripts;

print "\n##deleting a script\n";
&deletescript('test1');
print $sieve->{'Error'}."\n";

print "\n##listing scripts\n";
print &listscripts;
print $sieve->{'Error'}."\n";

print "\n##closing connection\n";
&closesieve;
print $sieve->{'Error'}."\n";

}
1;
