#!/usr/local/bin/perl
# index.cgi
# Display a list of known filesystems, and indicate which are currently mounted

require './mount-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("mount fstab vfstab", "man"));

# List filesystems from fstab and mtab
@mounted = &list_mounted();
$yes = $text{'yes'};
$no = "<font color=#ff0000>$text{'no'}</a>";
foreach (&list_fstypes()) { $can_edit{$_}++; }
$i = 0;
foreach $m (&list_mounts()) {
	$m->[0] = "swap" if ($m->[2] eq "swap");
	$mounts{$m->[0],$m->[1]} = $i++;
	push(@all, $m);
	}
$i = 0;
foreach $m (&list_mounted()) {
	$m->[0] = "swap" if ($m->[2] eq "swap");
	$mounted{$m->[0],$m->[1]} = $i++;
	push(@all, $m) if (!defined($mounts{$m->[0],$m->[1]}));
	}

# Sort by chosen mode
if ($config{'sort_mode'} == 2) {
	@all = sort { lc($a->[0]) cmp lc($b->[0]) } @all;
	}
elsif ($config{'sort_mode'} == 1) {
	@all = sort { &fstype_name($a->[2]) cmp &fstype_name($b->[2]) } @all;
	}

# Build visible filesystems list
foreach $m (@all) {
	@minfo = @$m;
	$p = &simplify_mount_path($minfo[0], $minfo[2]);
	next if ($ignore{$minfo[2]});
	@mmodes = &mount_modes($minfo[2], $minfo[0], $minfo[1]);
	$canedit = $can_edit{$minfo[2]} && !$mmodes[4] &&
            	   &can_edit_fs(@minfo);
	next if (!$canedit && $access{'hide'});
	push(@visible, $m);
	}

if (@visible) {
	# Show table of all visible filesystems
	&show_button();
	print "<table width=100% border>\n";
	print "<tr $tb> <td><b>$text{'index_dir'}</b></td>\n",
	      "<td><b>$text{'index_type'}</b></td>\n",
	      "<td><b>$text{'index_dev'}</b></td>\n",
	      "<td><b>$text{'index_use'}</b></td>\n",
	      "<td><b>$text{'index_perm'}</b></td> </tr>\n";
	foreach $m (@visible) {
		@minfo = @$m;
		$p = &simplify_mount_path($minfo[0], $minfo[2]);

		$midx = $mounts{$minfo[0],$minfo[1]};
		$medidx = $mounted{$minfo[0],$minfo[1]};
		@mmodes = &mount_modes($minfo[2], $minfo[0], $minfo[1]);
		$canedit = $can_edit{$minfo[2]} && !$mmodes[4] &&
			   &can_edit_fs(@minfo);
		print "<tr $cb>\n";
		if ($canedit && !$access{'only'}) {
			if (defined($midx)) {
				print "<td><a href=\"edit_mount.cgi?index=$midx\">",
				      "$p</a></td>\n",
				}
			else {
				print "<td><a href=\"edit_mount.cgi?temp=1&index=$medidx\">",
				      "$p</a></td>\n",
				}
			}
		else {
			print "<td>$p</td>\n";
			}
		local $fsn = &fstype_name($minfo[2]);
		$fsn .= " ($minfo[2])" if (uc($fsn) ne uc($minfo[2]));
		print "<td>",$minfo[2] eq "*" ? $text{'index_auto'} : $fsn,"</td>\n";
		print "<td>",&device_name($minfo[1]),"</td>\n";
		if (&can_edit_fs(@minfo)) {
			printf "<td>%s</td>\n",
				defined($medidx) ?
				"<a href='unmount.cgi?index=$medidx'>$yes</a>" :
				"<a href='mount.cgi?index=$midx'>$no</a>";
			}
		else {
			printf "<td>%s</td>\n", defined($medidx) ? $yes : $no;
			}
		printf "<td>%s</td>\n", defined($midx) ? $yes : $no;
		print "</tr>\n";
		}

	print "</table><br>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
&show_button();

&ui_print_footer("/", $text{'index'});

sub simplify_mount_path
{
if ($_[1] eq "swap") {
	return "<i>$text{'index_swap'}</i>";
	}
elsif (length($_[0]) > 20) {
	return &html_escape("... ".substr($_[0], length($_[0])-20));
	}
else {
	return &html_escape($_[0]);
	}
}

sub show_button
{
return if (!$access{'create'} || $access{'only'});
local %donefs;
print "<form action=\"edit_mount.cgi\">\n";
print "<input type=submit value=\"$text{'index_add'}\"> $text{'index_type'}:\n";
print "<select name=type>\n";
local $fs;
foreach $fs (sort { &fstype_name($a) cmp &fstype_name($b) } &list_fstypes()) {
	local $nm = &fstype_name($fs);
	if (!$donefs{$nm}++ && &can_fstype($fs)) {
		print "<option value=\"$fs\">$nm ($fs)\n";
		}
	}
print "</select></form>\n";
}

