#!/usr/local/bin/perl
# save_bootup.cgi
# Change whether lots of actions are run at boot or not

require './init-lib.pl';
&ReadParse();

@iacts = &list_actions();
foreach $a (@iacts) {
	local @ac = split(/\s+/, $a);
	$acts{$ac[0]} = \@ac;
	}
@boot = &get_inittab_runlevel();
$dd = $config{'daemons_dir'};
$dig = $config{'order_digits'};

# Go through all the changed actions
foreach $a (keys %in) {
	next if (!$acts{$a});

	# Get current status
	local ($boot, $rlboot, %daemon, $daemon);
	foreach $s (&action_levels('S', $a)) {
		local ($l, $p) = split(/\s+/, $s);
		$rlboot = $boot = 1 if (&indexof($l, @boot) >= 0);
		}
	if ($dd && &read_env_file("$dd/$a", \%daemon)) {
		$daemon = 1;
		}
	if ($boot && $daemon) {
		$boot = lc($daemon{'ONBOOT'}) eq 'yes' ? 1 : 0;
		}

	if (!$boot && $in{$a}) {
		# Change to start at boot
		&add_rl_action($a, $boot[0], 'S', "9" x $dig) if (!$rlboot);
		if ($daemon) {
			&lock_file("$dd/$a");
			$daemon{'ONBOOT'} = 'yes';
			&write_env_file("$dd/$a", \%daemon);
			&unlock_file("$dd/$a");
			}
		$done{$a} = 1;
		}
	elsif ($boot && !$in{$a}) {
		# Change to stop at boot
		if ($daemon) {
			&lock_file("$dd/$a");
			$daemon{'ONBOOT'} = 'no';
			&write_env_file("$dd/$a", \%daemon);
			&unlock_file("$dd/$a");
			}
		else {
			foreach (&action_levels('S', $a)) {
				/^(\S+)\s+(\S+)\s+(\S+)$/;
				&delete_rl_action($a, $1, 'S');
				}
			}
		$done{$a} = 0;
		}
	}
&webmin_log("bootup", undef, undef, \%done);
&redirect("");

