#!/usr/local/bin/perl
# edit_user.cgi
# Edit a new or existing webmin user

require './acl-lib.pl';
&foreign_require("webmin", "webmin-lib.pl");

&ReadParse();
if ($in{'user'}) {
	# Editing an existing user
	&can_edit_user($in{'user'}) || &error($text{'edit_euser'});
	&header($text{'edit_title'}, "");
	foreach $u (&list_users()) {
		if ($u->{'name'} eq $in{'user'}) {
			%user = %$u;
			}
		if ($u->{'name'} eq $base_remote_user) {
			$me = $u;
			}
		}
	}
else {
	# Creating a new user
	$access{'create'} || &error($text{'edit_ecreate'});
	&header($text{'edit_title2'}, "");
	foreach $u (&list_users()) {
		if ($u->{'name'} eq $in{'clone'}) {
			$user{'modules'} = $u->{'modules'};
			$user{'lang'} = $u->{'lang'};
			}
		if ($u->{'name'} eq $base_remote_user) {
			$me = $u;
			}
		}
	$user{'skill'} = $user{'risk'} = 'high' if ($in{'risk'});
	}
print "<hr>\n";

print "<form action=save_user.cgi method=post>\n";
if ($in{'user'}) {
	print "<input type=hidden name=old value=\"$user{'name'}\">\n";
	print "<input type=hidden name=oldpass value=\"$user{'pass'}\">\n";
	}
if ($in{'clone'}) {
	print "<input type=hidden name=clone value=\"$in{'clone'}\">\n";
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_rights'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
if ($access{'rename'} || !$in{'user'}) {
	print "<td><input name=name size=25 ",
	      "value=\"$user{'name'}\"></td>\n";
	}
else {
	print "<td>$user{'name'}</td>\n";
	}

@glist = &list_groups();
@mcan = $access{'gassign'} eq '*' ?
		( ( map { $_->{'name'} } @glist ), '_none' ) :
		split(/\s+/, $access{'gassign'});
map { $gcan{$_}++ } @mcan;
if (@glist && %gcan && !$in{'risk'} && !$user{'risk'}) {
	print "<td><b>$text{'edit_group'}</b></td>\n";
	print "<td><select name=group>\n";
	foreach $g (@glist) {
		local $mem = &indexof($user{'name'}, @{$g->{'members'}}) >= 0;
		next if (!$gcan{$g->{'name'}} && !$mem);
		printf "<option %s>%s\n",
			$mem ?  'selected' : '', $g->{'name'};
		$group = $g if ($mem);
		}
	printf "<option value='' %s>&lt;%s&gt;\n",
		$group ? '' : 'selected', $text{'edit_none'}
			if ($gcan{'_none'});
	print "</select></td>\n";
	}
print "</tr>\n";

print "<tr> <td><b>$text{'edit_pass'}</b></td> <td colspan=3>\n";
print "<select name=pass_def>\n";
printf "<option value=0 %s> $text{'edit_set'} ..\n",
	$in{'user'} ? "" : "selected";
if ($in{'user'}) {
	printf "<option value=1 %s> %s\n",
		$user{'sync'} || $user{'pass'} eq 'x' || $user{'pass'} eq '*LK*' ?
			"" : "selected", $text{'edit_dont'};
	}
printf "<option value=3 %s> $text{'edit_unix'}\n",
	$user{'pass'} eq 'x' ? "selected" : "";
if ($user{'sync'}) {
	printf "<option value=2 %s> $text{'edit_same'}\n",
		$user{'sync'} && $user{'pass'} ne 'x' ? "selected" : "";
	}
&get_miniserv_config(\%miniserv);
if ($miniserv{'extauth'}) {
	printf "<option value=5 %s> $text{'edit_extauth'}\n",
		$user{'pass'} eq 'e' ? "selected" : "";
	}
printf "<option value=4 %s> $text{'edit_lock'}\n",
	$user{'pass'} eq '*LK*' ? "selected" : "";
print "</select><input type=password name=pass size=25></td> </tr>\n";

if ($access{'chcert'}) {
	print "<tr> <td><b>$text{'edit_cert'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=cert_def value=1 %s> %s\n",
		$user{'cert'} ? '' : 'checked', $text{'edit_none'};
	printf "<input type=radio name=cert_def value=0 %s>\n",
		$user{'cert'} ? 'checked' : '';
	print "<input name=cert size=50 value='$user{'cert'}'></td> </tr>\n";
	}

if ($access{'lang'}) {
	print "<tr> <td><b>$text{'edit_lang'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=lang_def value=1 %s> %s\n",
		$user{'lang'} ? '' : 'checked', $text{'default'};
	printf "<input type=radio name=lang_def value=0 %s>\n",
		$user{'lang'} ? 'checked' : '';
	print "<select name=lang>\n";
	foreach $l (&list_languages()) {
		printf "<option value=%s %s>%s (%s)\n",
			$l->{'lang'},
			$user{'lang'} eq $l->{'lang'} ? 'selected' : '',
			$l->{'desc'}, uc($l->{'lang'});
		}
	print "</select></td> </tr>\n";
	}

if ($access{'cats'}) {
	print "<tr> <td><b>$text{'edit_notabs'}</b></td> <td colspan=2>\n";
	printf "<input type=radio name=notabs value=1 %s> %s\n",
		$user{'notabs'} == 1 ? 'checked' : '', $text{'yes'};
	printf "<input type=radio name=notabs value=2 %s> %s\n",
		$user{'notabs'} == 2 ? 'checked' : '', $text{'no'};
	printf "<input type=radio name=notabs value=0 %s> %s</td> </tr>\n",
		$user{'notabs'} == 0 ? 'checked' : '', $text{'default'};
	}

if ($access{'theme'}) {
	print "<tr> <td><b>$text{'edit_theme'}</b></td> <td colspan=2>\n";
	printf "<input type=radio name=theme_def value=1 %s> %s\n",
		defined($user{'theme'}) ? "" : "checked", $text{'edit_themeglobal'};
	printf "<input type=radio name=theme_def value=0 %s>\n",
		defined($user{'theme'}) ? "checked" : "";
	print "<select name=theme>\n";
	foreach $t ( { 'desc' => $text{'edit_themedef'} },
		     &foreign_call("webmin", "list_themes")) {
		printf "<option value='%s' %s>%s\n",
		  $t->{'dir'}, $user{'theme'} eq $t->{'dir'} ? 'selected' : '',
		  $t->{'desc'};
		}
	print "</select></td> </tr>\n";
	}

if ($access{'ips'}) {
	print "<tr> <td><b>$text{'edit_ips'}</b></td>\n";
	print "<td colspan=3><table><tr>\n";
	printf "<td nowrap><input name=ipmode type=radio value=0 %s> %s<br>\n",
		$user{'allow'} || $user{'deny'} ? '' : 'checked',
		$text{'edit_all'};
	printf "<input name=ipmode type=radio value=1 %s> %s<br>\n",
		$user{'allow'} ? 'checked' : '', $text{'edit_allow'};
	printf "<input name=ipmode type=radio value=2 %s> %s</td> <td>\n",
		$user{'deny'} ? 'checked' : '', $text{'edit_deny'};
	print "<textarea name=ips rows=4 cols=30>",
	      join("\n", split(/\s+/, $user{'allow'} ? $user{'allow'}
						     : $user{'deny'})),
	      "</textarea></td>\n";
	print "</td> <td>$text{'edit_ipdesc'}</td></tr></table> </tr>\n";
	}

if ($user{'risk'} || $in{'risk'}) {
	# Creating or editing a risk-level user
	print "<tr> <td><b>$text{'edit_risk'}</b></td> <td colspan=3>\n";
	foreach $s ('high', 'medium', 'low') {
		printf "<input type=radio name=risk value='%s' %s> %s\n",
		    $s, $user{'risk'} eq $s ? 'checked' : '',
		    $text{"edit_risk_$s"};
		}
	print "</td> </tr>\n";

	print "<tr> <td><b>$text{'edit_skill'}</b></td> <td colspan=3>\n";
	foreach $s ('high', 'medium', 'low') {
		printf "<input type=radio name=skill value='%s' %s> %s\n",
		    $s, $user{'skill'} eq $s ? 'checked' : '',
		    $text{"skill_$s"};
		}
	print "</td> </tr>\n";
	}
else {
	# Creating or editing a normal user
	@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
		$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
				       &list_modules();
	map { $mcan{$_}++ } @mcan;
	map { $has{$_}++ } @{$user{'modules'}};
	map { $has{$_} = 0 } $group ? @{$group->{'modules'}} : ();

	@mlist = grep { $access{'others'} || $has{$_->{'dir'}} || $mcan{$_->{'dir'}} } &list_module_infos();
	print "<tr> <td valign=top><b>$text{'edit_modules'}</b><br>",
	      "$text{'edit_groupmods'}</td>\n";
	print "<td colspan=3>\n";
	print "<a href='' onClick='document.forms[0].mod.checked = true; for(i=0; i<document.forms[0].mod.length; i++) { document.forms[0].mod[i].checked = true; } return false'>$text{'edit_selall'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].mod.checked = !document.forms[0].mod.checked; for(i=0; i<document.forms[0].mod.length; i++) { document.forms[0].mod[i].checked = !document.forms[0].mod[i].checked; } return false'>$text{'edit_invert'}</a><br>\n";
	print "<table width=100% cellpadding=0 cellspacing=0>\n";
	foreach $m (@mlist) {
		local $md = $m->{'dir'};
		if (!$sw) { print "<tr>\n"; }
		print "<td width=50%>";
		if ($mcan{$md}) {
			printf"<input type=checkbox name=mod value=$md %s> %s\n",
			      $has{$md} ? "checked" : "", $m->{'desc'};
			}
		else {
			printf "<img src=images/%s.gif> %s\n",
			    $has{$md} ? 'tick' : 'empty', $m->{'desc'};
			}
		print "</td>";
		if ($sw) { print "<tr>\n"; }
		$sw = !$sw;
		}
	print "</table>\n";
	print "<a href='' onClick='document.forms[0].mod.checked = true; for(i=0; i<document.forms[0].mod.length; i++) { document.forms[0].mod[i].checked = true; } return false'>$text{'edit_selall'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].mod.checked = !document.forms[0].mod.checked; for(i=0; i<document.forms[0].mod.length; i++) { document.forms[0].mod[i].checked = !document.forms[0].mod[i].checked; } return false'>$text{'edit_invert'}</a>\n";
	print "</td> </tr>\n";
	}
print "</table></td> </tr></table>\n";

print "<table width=100%> <tr>\n";
print "<td align=left width=20%><input type=submit value=\"$text{'save'}\"></td></form>\n";
if ($in{'user'}) {
	if (!$group) {
		print "<form action=hide_form.cgi>\n";
		print "<input type=hidden name=user value=\"$in{'user'}\">\n";
		print "<td align=center width=20%>",
		      "<input type=submit value=\"$text{'edit_hide'}\"></td></form>\n";
		}
	else { print "<td width=20%></td>\n"; }

	if ($access{'create'} && !$group) {
		print "<form action=edit_user.cgi>\n";
		print "<input type=hidden name=clone value=\"$in{'user'}\">\n";
		print "<td align=center width=20%>",
		      "<input type=submit value=\"$text{'edit_clone'}\">",
		      "</td></form>\n";
		}
	else { print "<td width=20%></td>\n"; }

	&read_acl(\%acl);
	if (&foreign_check("webminlog") &&
	    $acl{$base_remote_user,'webminlog'}) {
		print "<form action=/webminlog/search.cgi>\n";
		print "<input type=hidden name=uall value=0>\n";
		print "<input type=hidden name=user value='$in{'user'}'>\n";
		print "<input type=hidden name=mall value=1>\n";
		print "<input type=hidden name=tall value=0>\n";
		print "<td align=center width=20%>",
		      "<input type=submit value=\"$text{'edit_log'}\">",
		      "</td></form>\n";
		}
	else { print "<td width=20%></td>\n"; }

	if ($access{'delete'}) {
		print "<form action=delete_user.cgi>\n";
		print "<input type=hidden name=user value=\"$in{'user'}\">\n";
		print "<td align=right width=20%>",
		      "<input type=submit value=\"$text{'delete'}\"></td></form>\n";
		}
	else { print "<td width=20%></td>\n"; }
	}
print "</tr> </table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

