#!/usr/local/bin/perl
# edit_limits.cgi
# Display access control and usage limits for this domain's user

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} == 1 && &can_edit_domain($d) || &error($text{'edit_ecannot'});

&ui_print_header(&domain_in($d), $text{'limits_title'}, "");

#print "$text{'limits_desc'}<p>\n";

print "<form action=save_limits.cgi method=post>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'limits_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_domain'}</b></td>\n";
print "<td><tt>$d->{'dom'}</tt></td> </tr>\n";

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
print "<td><tt>$d->{'user'}</tt></td> </tr>\n";

# Maximum allowed mailboxes
print "<tr> <td><b>$text{'form_mailboxlimit'}</b></td> <td colspan=2>\n";
print &ui_opt_textbox("mailboxlimit", $d->{'mailboxlimit'}, 4,
	      $text{'form_unlimit'}, $text{'form_atmost'}),"</td> </tr>\n";

# Maximum allowed dbs
print "<tr> <td><b>$text{'form_dbslimit'}</b></td> <td colspan=2>\n";
print &ui_opt_textbox("dbslimit", $d->{'dbslimit'}, 4,
	      $text{'form_unlimit'}, $text{'form_atmost'}),"</td> </tr>\n";

# Can choose db name
print "<tr> <td><b>$text{'limits_nodbname'}</b></td>\n";
print "<td>",&ui_radio("nodbname", $d->{'nodbname'} ? 1 : 0,
	       [ [ 0, $text{'yes'} ], [ 1, $text{'no'} ] ]),"</td> </tr>\n";

# Can rename domains
print "<tr> <td><b>$text{'limits_norename'}</b></td>\n";
print "<td>",&ui_radio("norename", $d->{'norename'} ? 1 : 0,
	       [ [ 0, $text{'yes'} ], [ 1, $text{'no'} ] ]),"</td> </tr>\n";

# Force sub-domain under master domain
print "<tr> <td><b>$text{'limits_forceunder'}</b></td>\n";
print "<td>",&ui_radio("forceunder", $d->{'forceunder'} ? 1 : 0,
	       [ [ 1, $text{'yes'} ], [ 0, $text{'no'} ] ]),"</td> </tr>\n";

# Can create and edit domains?
$dlm = $d->{'domslimit'} eq "" ? 1 :
       $d->{'domslimit'} eq "*" ? 2 : 0;
print "<tr> <td><b>$text{'form_domslimit'}</b></td> <td colspan=2>\n";
printf "<input type=radio name=domslimit_def value=1 %s> %s\n",
	$dlm == 1 ? "checked" : "",
	$text{'no'};
printf "<input type=radio name=domslimit_def value=2 %s> %s\n",
	$dlm == 2 ? "checked" : "",
	$text{'form_domsunlimit'};
printf "<input type=radio name=domslimit_def value=0 %s> %s\n",
	$dlm == 0 ? "checked" : "",
	$text{'form_domsyes'};
printf "<input name=domslimit value='%s' size=4></td></tr>\n",
	$dlm == 0 ? $d->{'domslimit'} : "";

# Allowed features
print "<tr> <td valign=top><b>$text{'limits_features'}</b></td>\n";
print "<td colspan=3><table>\n";
$i = 0;
foreach $f (@opt_features, "virt") {
	print "<tr>\n" if ($i%2 == 0);
	printf "<td><input type=checkbox name=features value=%s %s> %s</td>\n",
		$f, $d->{"limit_$f"} ? "checked" : "",
		$text{'feature_'.$f} || $f;
	print "</tr>\n" if ($i++%2 == 1);
	}
foreach $f (@feature_plugins) {
	print "<tr>\n" if ($i%2 == 0);
	printf "<td><input type=checkbox name=features value=%s %s> %s</td>\n",
		$f, $d->{"limit_$f"} ? "checked" : "",
		&plugin_call($f, "feature_name");
	print "</tr>\n" if ($i++%2 == 1);
	}
print "</table></td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		 "", $text{'index_return'});

