# domain-controller-lib.pl

do '../web-lib.pl';
&init_config();
require '../ui-lib.pl';

&foreign_require("proc", "proc-lib.pl");
&foreign_require("webmin", "webmin-lib.pl");
&foreign_require("samba", "samba-lib.pl");
&foreign_require("useradmin", "user-lib.pl");
&foreign_require("dhcpd", "dhcpd-lib.pl");
&foreign_require("dhcpd", "params-lib.pl");
&foreign_require("net", "net-lib.pl");
&foreign_require("squid", "squid-lib.pl");

require '../net/net-lib.pl';
@ifaces = &get_interface_defs();
@act = &active_interfaces();
@boot = &boot_interfaces();

&foreign_require("firewall", "firewall-lib.pl");

# set_root_password ( Username, NewPassword )
sub set_root_password {
	local ($username, $password)=@_;
	@cmd = ( "$config{'passwd_cmd'} '$username'" );

	&additional_log('exec', undef, $cmd[0]);
	local ($fh, $fpid) = &foreign_call("proc", "pty_process_exec", @cmd);
	while(1) {
		local $rv = &wait_for($fh, '(new|re-enter).*:',
					   '(old|current|login).*:',
					   'pick a password');
		$out .= $wait_for_input;
		sleep(1);
		if ($rv == 0) {
			syswrite($fh, $password."\n", length($password)+1);
			}
		elsif ($rv == 1) {
            $count = 10;
			}
		elsif ($rv == 2) {
			syswrite($fh, "1\n", 2);
			}
		else {
			last;
			}
		last if (++$count > 10);
		}
	close($fh);
	waitpid($fpid, 0);

    $a = (! system("echo -e \"${password}\\n${password}\" | smbpasswd -a -s root"));
    ($a = 0) if ($? || $count > 10);

	&error(&text('passwd_ecmd', "<tt>$config{'passwd_cmd'}</tt>", "<pre>$out</pre>")) if ($? || $count > 10);
	&webmin_log("passwd", undef, $username);
    return $a;
}

# ?
sub setup_dhcp {
	local ($netAddress, $netmask, $low, $hi, $gateway, $dns, $domainName)=@_;

    open(DF, "> $config{'sbsdhcpfile'}") or die("Unable to open the configuration file !\n");
    print DF "\# The dhcpd configuration file that made by SBS Wizard.\n";
    print DF "default-lease-time 600;\n";
    print DF "max-lease-time 7200;\n";
    if ($domainName) {
      print DF "option domain-name \"${domainName}\";\n";
      print DF "option domain-name-servers $dns;\n";
    };
    print DF "subnet $netAddress netmask $netmask {\n";
    print DF "  range ${low} ${hi};\n";
    if ($domainName) {
      print DF "  option domain-name \"${domainName}\";\n";
      print DF "  option domain-name-servers ${dns};\n";
    };
    if ($gateway) {
      print DF "  option routers ${gateway};\n";
    }
    print DF "}\n\n";
    close(DF);

	&webmin_log('create' ,
		    'subnet', "", \%in);
    return 1;
}

# ?
sub setup_dns {
	local ($domainName, $hostname, $ip)=@_;

    open(DF, "> $config{'sbsdnsfile'}") or die("Unable to open the configuration file !\n");
    print DF "\/\/ The dns configuration file that made by SBS Wizard.\n";
    print DF "zone \"${domainName}\" {\n";
    print DF "       type master;\n";
    print DF "       file \"$config{'sbsdnsfile2'}\";\n";
    print DF "       };\n\n";
    close(DF);

    open(DF, "> $config{'sbsdnsfile2'}") or die("Unable to open the configuration file !\n");
    print DF "\$ttl 38400\n";
    print DF "@\t\tIN\tSOA    ${hostname}.${domainName}.    root.${hostname}.${domainName}. (\n";
    print DF "                     ".time()."\n";
    print DF "                     10800\n";
    print DF "                     3600\n";
    print DF "                     604800\n";
    print DF "                     38400 )\n\n";
    print DF "@\t\tIN\tNS\t${hostname}.${domainName}. \n";
    print DF "\t\tIN\tA\t$ip \n";
    print DF "\t\tIN\tTXT\t\"${domainName} - Configured by SBS\" \n";
    print DF "${hostname}\tIN\tA\t$ip \n";
    print DF "\n";
    close(DF);

    return 1;
}

# ?
sub setup_pdc{
local ($netbios_name, $workgroup_name)=@_;
require '../samba/samba-lib.pl';
&lock_file($config{'smb_conf'});
$global = &get_share("global");
%access = &get_module_acl();
&error_setup("<blink><font color=red>$text{'eacl_aviol'}</font></blink>");
&error("$text{'eacl_np'} $text{'eacl_pcs'}") unless $access{'conf_smb'};
$whatfailed = $text{'savesmb_fail'};
&setval("netbios name", $netbios_name);
&setval("workgroup",$workgroup_name);
&setval("unix password sync" ,"yes");
&setval("add machine script","/var/lib/samba/addMachine.pl %m %I");
&setval("local master","yes");
&setval("os level","34");
&setval("domain master" , "yes");
&setval("time server" ,"yes");
&setval("follow symlinks","no");
&setval("invalid users","");
&setval("encrypt passwords","yes");
&setval("security","user");
&setval("logon home","\\\\%L\\%u");
&setval("logon script","%U.bat");
&setval("passdb backend","tdbsam");
&setval("domain logons","yes");
&setval("pam password change","yes");
if ($global) { &modify_share("global", "global");}
else { &create_share("global");}

$netlogon = &get_share("netlogon");
&setval("root preexec","/var/lib/samba/genlogon.pl %u %L"," ");
&setval("writable" , "no"," ");
&setval("write list","ntadmin");
&setval("path","/var/lib/samba/netlogon");
if ($netlogon) { &modify_share("netlogon","netlogon"); }
else { &create_share("netlogon"); }

$profiles = &get_share("profiles");
&setval("path","/home/%u/profiles");
&setval("read only","no");
&setval("profile acls","yes");
if ($profiles) { &modify_share("profiles","profiles"); }
else { &create_share("profiles"); }

$homes = &get_share("homes");
&setval("valid users","$S");
&setval("read only","no");
&setval("browseable","no");
if ($homes) { &modify_share("homes","homes"); }
else { &create_share("homes"); }

&unlock_file($config{'smb_conf'});

return 1;
}

sub apply_changes_samba {
    return system "$config{'samba_init'} restart";
}

sub apply_changes_dhcp {
    return system "$config{'dhcpd_init'} restart";
}

sub apply_changes_dns {
    return system "$config{'dns_init'} restart";
}

#getMethod("eth0"); #returns dhcp or static
sub getMethod{
	local $intf = @_[0];
	foreach $iface (@ifaces) {
		my ($name, $addrfam, $method, $options) = @$iface;
		return $method	if ($name=~$intf);
	}

}

sub getNetInfo{
	local $intf = @_[0];
	foreach $iface (@act) {
		return ($iface)  if ($iface->{'name'}=~$intf);
	}

}

#getActivity("eth0"); #returns 0 or 1 
sub getActivity{
	local $intf = @_[0];
	foreach $iface (@act) {
		return ($iface->{'up'})  if ($iface->{'name'}=~$intf);
	}
}

sub get_gateway
{
local ($router, $addr);
foreach $iface (@ifaces) {
	foreach $o (@{$iface->[3]}) {
		if ($o->[0] eq 'gateway') {
			return ( $o->[1] );
			}
		}
	}
return ( );
}
#setIP("eth0","192.168.0.24","255.255.255.254"); sets an static ip for ethernet
sub setIP{
	local ($name,$IPaddr,$net,$newgate) = @_;
	$a->{'fullname'} = $name;
	$a->{'name'} = $name;
	$a->{'gateway'} = &get_gateway() if(!$newgate);
	$a->{'dhcp'} = 0;
	$a->{'up'} = 1;
	&valid_boot_address($IPaddr) ||&error("Bad IP : ". $IPaddr);
	$a->{'address'} = $IPaddr;
	&check_ipaddress($net) ||&error("Bad Netmask : ".$net);
	$a->{'netmask'} = $net;
	&activate_interface($a);
	&save_interface($a);
    return 1;
}

#listInterfaces("eth") returns an array containing interfaces
# that have eth on their name.
sub listInterfaces() {
	local ($pattern) = @_;
    @mylist = ();
    $pattern .= ".*";
	foreach $iface (@ifaces) {
		my ($name, $addrfam, $method, $options) = @$iface;
        $_ = $name;
        if (/$pattern/) {
            push(@mylist,$_);
        }
    }
    return @mylist;
}

# returns (netAddress,netmask,low,hi,ip)
sub getDefaultVals {
    local ($name) = @_;
    if (! $name) {
        $name = "eth0";
    }
    if (getMethod($name) ne "static") {
        return ("192.168.1.0","255.255.255.0","192.168.1.9","192.168.1.254","192.168.1.1","192.168.1.1");
    }
    $netinfo = getNetInfo($name);
    $systemIP = $netinfo->{'address'};
    $systemGW = &get_gateway();
    $systemNetmask = $netinfo->{'netmask'};
    $systemAddress = &compute_network($systemIP, $systemNetmask);
    $low = &integer_to_ip(&ip_to_integer($systemAddress) + 9);
    $hi = &integer_to_ip(&ip_to_integer(&compute_broadcast($systemIP,$systemNetmask)) - 1);
    return ($systemAddress, $systemNetmask, $low, $hi, $systemIP, $systemGW);
}

sub internet_sharing_init
{

$conf = &squid::get_config();

	# Check for IPTables configuration file

	if (not -s $iptables_save_file) {
    		&lock_file($iptables_save_file);
		if (defined(&firewall::unapply_iptables)) {
		&firewall::unapply_iptables();
		}
		else {
		&backquote_logged("iptables-save >$iptables_save_file 2>&1");
		}
		&firewall::create_firewall_init();
		&unlock_file($iptables_save_file);
	}

# Read the Tables

    @tables = &firewall::get_iptables_save();
    ($nat) = grep { $_->{'name'} eq 'nat'} @tables;

    foreach $r (@{$nat->{'rules'}}) {
    	if ($r->{'chain'} eq 'PREROUTING' &&
    	    $r->{'j'}->[1] eq 'REDIRECT' &&
    	    $r->{'dport'}->[1] == 80 &&
    	    $r->{'to-ports'}->[1] == 3128) {
    		$rule = $r;
   	    }
    }

    if ($rule) {
    	return(1);
    }
    else {
    	return(0);
    }
}

sub internet_sharing_enable
{
	# Configure the Squid
	&lock_file($config{'squid_conf'});
	&squid::save_directive($conf, "httpd_port", []);
	&squid::save_directive($conf, "httpd_accel_port",
			[ { 'name' => 'httpd_accel_port',
			    'values' => [ 80 ] } ]);
	&squid::save_directive($conf, "httpd_accel_host",
			[ { 'name' => 'httpd_accel_host',
			    'values' => [ 'virtual' ] } ]);
	&squid::save_directive($conf, "httpd_accel_uses_host_header",
			[ { 'name' => 'httpd_accel_uses_host_header',
			    'values' => [ 'on' ] } ]);
	&squid::flush_file_lines();
	&unlock_file($config{'squid_conf'});
	if ("$config{'squid_restart'}") {
	    &backquote_logged("$config{'squid_restart'}");
	}    
	# Configure the IPTables
	if ($rule) {
		splice(@{$nat->{'rules'}}, $rule->{'index'}, 1);
	}
	$rule = { 'chain' => 'PREROUTING',
	  'j' => [ '', 'REDIRECT' ],
	  'p' => [ '', 'tcp' ],
	  'm' => [ '', 'tcp' ],
	  'dport' => [ '', 80 ],
	  'to-ports' => [ '', 3128 ],
	  'i' => [ '', $_[0] ],
	  'cmt' => 'Ubuntu-Wizard Internet Sharing' };
	push(@{$nat->{'rules'}}, $rule);
	&lock_file($firewall::iptables_save_file);
	&firewall::save_table($nat);
	&unlock_file($firewall::iptables_save_file);
	if (defined(&firewall::apply_iptables)) {
	    &firewall::apply_iptables();
	}
	return 1;
}


sub internet_sharing_disable
{
	# Configure the Squid
	&lock_file($config{'squid_conf'});
	&squid::save_directive($conf, "httpd_accel_port", []);
	&squid::save_directive($conf, "httpd_accel_host", []);
	&squid::save_directive($conf, "httpd_accel_uses_host_header", []);
	&flush_file_lines();
	&unlock_file($config{'squid_conf'});
	if ("$config{'squid_restart'}") {
	    &backquote_logged("$config{'squid_restart'}");
	}    
	
	# Configure the IPTables
	if ($rule) {
		splice(@{$nat->{'rules'}}, $rule->{'index'}, 1);
	}
	&lock_file($firewall::iptables_save_file);
	&firewall::save_table($nat);
	&unlock_file($firewall::iptables_save_file);
	if (defined(&firewall::apply_iptables)) {
	    &firewall::apply_iptables();
	}

    return 1;}
