#!/usr/local/bin/perl
# newdb.cgi
# Create a new database with one optional table

require './postgresql-lib.pl';
&ReadParse();
$access{'create'} || &error($text{'newdb_ecannot'});
&error_setup($text{'newdb_err'});

# Make sure maximum databases limit has not been exceeded
@alldbs = &list_databases();
@titles = grep { &can_edit_db($_) } @alldbs;
if ($access{'create'} == 2 && @titles >= $access{'max'}) {
	&error($text{'newdb_ecannot2'});
	}

$in{'db'} =~ /^[A-z0-9\.\-]+$/ || &error($text{'newdb_edb'});
$user = $in{'user_def'} ? "" : "with owner=\"$in{'user'}\"";
if ($in{'path_def'}) {
	&execute_sql_logged($config{'basedb'}, "create database $in{'db'} $user");
	}
else {
	$in{'path'} || &error($text{'newdb_epath'});
	&execute_sql_logged($config{'basedb'}, "create database $in{'db'} ".
					       "with location = '$in{'path'}' $user");
	}
&webmin_log("create", "db", $in{'db'});
if ($access{'dbs'} ne '*') {
	$access{'dbs'} .= " " if ($access{'dbs'});
	$access{'dbs'} .= $in{'db'};
	&save_module_acl(\%access);
	}
&redirect("");

