/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef COOKIEJAR_H
#define COOKIEJAR_H

#include <QMap>
#include <QString>

class QHttpResponseHeader;
class QHttpRequestHeader;

class Cookie;

/**
* Simple cookie container.
*
* Container for cookies which parses the Set-Cookie headers of the response
* and generates the Cookie header for the request. All properties, including
* expiration date, domain and path are ignored.
*/
class CookieJar
{
public:
    /**
    * Constructor.
    */
    CookieJar();

    /**
    * Destructor.
    */
    ~CookieJar();

public:
    /**
    * Extract cookies from Set-Cookie headers of a response.
    */
    void extractCookies( const QHttpResponseHeader& response );

    /**
    * Insert Cookie header to the request.
    */
    void insertCookies( QHttpRequestHeader& request );

    /**
    * Remove all cookies.
    */
    void clear();

private:
    QMap<QString, Cookie> m_cookies;
};

#endif
