/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef CSVREPORTWRITER_H
#define CSVREPORTWRITER_H

#include <QStringList>

/**
* Class for writing reports in CSV format.
*
* This class is responsible for writing the reports into an CSV file.
*/
class CsvReportWriter
{
public:
    /**
    * Default constructor.
    */
    CsvReportWriter();

    /**
    * Destructor.
    */
    ~CsvReportWriter();

public:
    /**
    * Write a single row.
    */
    void writeRow( const QStringList& cells );

    /**
    * Return the field embedded in double quotes if necessary.
    */
    QString field( const QString& field );

    /**
    * Return the content of the generated CSV file.
    */
    QString result() const;

private:
    QStringList m_rows;
};

#endif
