/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef BOOKMARKSETTINGS_H
#define BOOKMARKSETTINGS_H

#include <QObject>
#include <QList>
#include <QStringList>

class Bookmark;

/**
* Class for loading and modifying bookmarks.
*/
class BookmarkSettings : public QObject
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    BookmarkSettings();

    /**
    * Destructor.
    */
    ~BookmarkSettings();

public:
    /**
    * Return all existing bookmarks.
    */
    const QList<Bookmark>& bookmarks() const { return m_bookmarks; }

    /**
    * Return the bookmark with given UUID.
    */
    Bookmark bookmark( const QString& uuid ) const; 

    /**
    * Replace the bookmart with given UUID.
    */
    void replaceBookmark( const QString& uuid, const Bookmark& bookmark );

    /**
    * Add a bookmark to the top of the list.
    *
    * The list is limited to ten entries.
    */
    void addBookmark( const Bookmark& bookmark );

    /**
    * Delete the bookmark with given UUID.
    */
    void deleteBookmark( const QString& uuid );

private:
    int findBookmark( const QString& uuid ) const;

    void openBookmarks();
    void saveBookmarks();

    QStringList serializeBookmark( const Bookmark& bookmark );
    Bookmark deserializeBookmark( const QStringList& list );

    QString obscure( const QString& text );

private:
    QList<Bookmark> m_bookmarks;
};

#endif
