/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DEFINITIONHELPER_H
#define DEFINITIONHELPER_H

#include "definitioninfo.h"

namespace WebIssues
{

class DefinitionInfo;

/**
* Functions providing attribute type names and metadata details.
*
* These functions return information used by the UI to display user friendly
* attribute type names and metadata details.
*
* @see DefinitionInfo
*/
class DefinitionHelper
{
public:
    /**
    * Return the name of an attribute type.
    *
    * @param type The attribute type.
    *
    * @return A user friendly name of the type.
    */
    static QString typeName( DefinitionInfo::Type type );

    /**
    * Return the details of an attribute definition.
    *
    * @param info The attribute definition.
    *
    * @return User friendly information about the attribute definition metadata.
    */
    static QString metadataDetails( const DefinitionInfo& info );

private:
    static QString textMetadataDetails( const DefinitionInfo& info );
    static QString enumMetadataDetails( const DefinitionInfo& info );
    static QString numericMetadataDetails( const DefinitionInfo& info );
    static QString dateTimeMetadataDetails( const DefinitionInfo& info );
    static QString userMetadataDetails( const DefinitionInfo& info );

    static QString tr( const char* text );
};

}

#endif
