/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TABLEMODELS_H
#define TABLEMODELS_H

#include "abstracttablemodel.h"

namespace WebIssues
{

/**
* Model providing information for the rows of the users table.
*/
class UsersTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    UsersTableModel( QObject* parent );

    /**
    * Destructor.
    */
    ~UsersTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );
};

/**
* Model providing information for the rows of the members table.
*/
class MembersTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param projectId Identifier of the project containing the members.
    */
    MembersTableModel( int projectId, QObject* parent );

    /**
    * Destructor.
    */
    ~MembersTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );

private:
    int m_projectId;
};

/**
* Model providing information for the rows of the issue types table.
*/
class TypesTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    TypesTableModel( QObject* parent );

    /**
    * Destructor.
    */
    ~TypesTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );
};

/**
* Model providing information for the rows of the attributes table.
*/
class AttributesTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    AttributesTableModel( QObject* parent );

    /**
    * Destructor.
    */
    ~AttributesTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );
};

/**
* Model providing information for the rows of the projects table.
*/
class ProjectsTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    ProjectsTableModel( QObject* parent );

    /**
    * Destructor.
    */
    ~ProjectsTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );
};

/**
* Model providing information for the rows of the folders table.
*/
class FoldersTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    FoldersTableModel( QObject* parent );

    /**
    * Destructor.
    */
    ~FoldersTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );
};

/**
* Model providing information for the rows of the issues table.
*/
class IssuesTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param folderId Identifier of the folder containing the issues.
    */
    IssuesTableModel( int folderId, QObject* parent );

    /**
    * Destructor.
    */
    ~IssuesTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

    QString toolTip( int id ) const;

    int compare( int id1, int id2, Column column ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );

private:
    int m_folderId;
};

/**
* Model providing information for the rows of the attachments table.
*/
class AttachmentsTableModel : public AbstractTableModel
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param issueId Identifier of the issue containing the attributes.
    */
    AttachmentsTableModel( int issueId, QObject* parent );

    /**
    * Destructor.
    */
    ~AttachmentsTableModel();

public: // overrides
    QString text( int id, Column column ) const;

    QPixmap icon( int id ) const;

    int compare( int id1, int id2, Column column ) const;

protected: // overrides
    void updateEvent( UpdateEvent* e );

private:
    int m_issueId;
};

}

#endif
