/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "finditemdialog.h"

#include <QLayout>
#include <QLabel>
#include <QSpinBox>

#include "data/datamanager.h"
#include "data/finditembatch.h"
#include "iconloader.h"

using namespace WebIssues;

FindItemDialog::FindItemDialog( QWidget* parent ) : CommandDialog( parent ),
    m_itemId( 0 ),
    m_issueId( 0 )
{
    setWindowTitle( tr( "Find Item" ) );
    setPrompt( tr( "Enter an issue, comment or attachment identifier:" ) );
    setPromptPixmap( IconLoader::pixmap( "find", 22 ) );

    showInfo( tr( "Enter identifier" ) );

    QHBoxLayout* layout = new QHBoxLayout();

    QLabel* label = new QLabel( tr( "&ID:" ), this );
    layout->addWidget( label, 0 );

    m_idSpin = new QSpinBox( this );
    m_idSpin->setRange( 1, INT_MAX );
    m_idSpin->setPrefix( "#" );
    layout->addWidget( m_idSpin, 1 );

    label->setBuddy( m_idSpin );

    setContentLayout( layout, true );

    m_idSpin->setFocus();
}

FindItemDialog::~FindItemDialog()
{
}

void FindItemDialog::findItem( int itemId )
{
    m_idSpin->setValue( itemId );

    accept();
}

void FindItemDialog::accept()
{
    m_itemId = m_idSpin->value();

    m_issueId = dataManager->findItem( m_itemId );
    if ( m_issueId != 0 ) {
        QDialog::accept();
        return;
    }

    FindItemBatch* batch = new FindItemBatch( m_itemId );

    executeBatch( batch );
}

bool FindItemDialog::batchSuccessful( AbstractBatch* batch )
{
    m_issueId = ( (FindItemBatch*)batch )->issueId();

    if ( m_issueId == 0 ) {
        showWarning( tr( "No item with this identifier was found" ) );
        return false;
    }

    return true;
}

#include "finditemdialog.moc"
