/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef FINDDIALOG_H
#define FINDDIALOG_H

#include <QDialog>
#include <QTextDocument>

class QLineEdit;
class QCheckBox;
class QDialogButtonBox;

namespace WebIssues
{

/**
* Dialog for finding text.
*/
class FindDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    FindDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~FindDialog();

public:
    /**
    * Set the text to find.
    */
    void setText( const QString& text );

    /**
    * Return the text to find.
    */
    QString text() const;

    /**
    * Set the find flags.
    */
    void setFlags( QTextDocument::FindFlags flags );

    /**
    * Return the find flags.
    */
    QTextDocument::FindFlags flags() const;

    /**
    * Return @c true if find is enabled.
    */
    bool isFindEnabled() const { return m_enabled; }

signals:
    /**
    * Emitted when the Find button is clicked.
    */
    void findClicked();

    /**
    * Emitted when find is enabled or disabled.
    */
    void findEnabled( bool enabled );

protected: // overrides
    void showEvent( QShowEvent* event );

private slots:
    void textChanged( const QString& text );

private:
    QLineEdit* m_edit;

    QCheckBox* m_wordCheckBox;
    QCheckBox* m_caseCheckBox;

    QDialogButtonBox* m_buttonBox;

    bool m_enabled;
};

}

#endif
