/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef UPDATEEVENT_H
#define UPDATEEVENT_H

#include <QEvent>

namespace WebIssues
{

/**
* Event sent to data observers when data is updated.
*
* Use DataManager::addObserver() to receive update events and DataManager::removeObserver()
* to stop receiving them.
*/
class UpdateEvent : public QEvent
{
public:
    /**
    * Logical unit of data.
    */
    enum Unit
    {
        /** Users and their membership. */
        Users,
        /** Types and attributes. */
        Types,
        /** Projects and folders. */
        Projects,
        /** Issues in a given folder. */
        Folder,
        /** Details of a given issue. */
        Issue
    };

    /**
    * Type of the event returned by QCustomEvent::type().
    */
    static const int Type = QEvent::User + 1;

public:
    /**
    * Constructor.
    *
    * @param unit Unit of data which was updated.
    *
    * @param id Identifier of the updated folder or issue.
    */
    UpdateEvent( Unit unit, int id );

    /**
    * Desctructor.
    */
    ~UpdateEvent();

public:
    /**
    * Return the unit of data which was updated.
    */
    Unit unit() const { return m_unit; }

    /**
    * Return the identifier of the updated folder or issue.
    */
    int id() const { return m_id; }

private:
    Unit m_unit;
    int m_id;
};

}

#endif
