/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "formdatamessage.h"

#include <QDateTime>

using namespace WebIssues;

FormDataMessage::FormDataMessage()
{
    m_boundary = QString( "nextPart-%1" ).arg( randomString( 12 ) );

    m_buffer.setBuffer( &m_body );
    m_buffer.open( QIODevice::WriteOnly );
}

FormDataMessage::~FormDataMessage()
{
}

void FormDataMessage::addField( const QString& name, const QByteArray& value )
{
    writeLine( QString( "--%1" ).arg( m_boundary ) );
    writeLine( QString( "Content-Disposition: form-data; name=\"%1\"" ).arg( name ) );
    writeLine();
    writeRawBytes( value );
    writeLine();
}

void FormDataMessage::addAttachment( const QString& name, const QString& fileName, const QByteArray& data )
{
    writeLine( QString( "--%1" ).arg( m_boundary ) );
    writeLine( QString( "Content-Disposition: form-data; name=\"%1\"; filename=\"%2\"" ).arg( name, fileName ) );
    writeLine( "Content-Type: application/octet-stream" );
    writeLine();
    writeRawBytes( data );
    writeLine();
}

void FormDataMessage::finish()
{
    writeLine( QString( "--%1--" ).arg( m_boundary ) );
}

QString FormDataMessage::contentType()
{
    return QString( "multipart/form-data; boundary=\"%1\"" ).arg( m_boundary );
}

QString FormDataMessage::randomString( int length )
{
    static bool init = false;
    if ( !init ) {
        srand( QDateTime::currentDateTime().toTime_t() );
        init = true;
    }

    QString result;
    result.resize( length );

    for ( int i = 0; i < length; i++ ) {
        int n = rand() % 62 + 48;
        if ( n > 57 )
            n += 7;
        if ( n > 90 )
            n += 6;
        result[ i ] = (char)n;
    }

    return result;
}

void FormDataMessage::writeLine()
{
    m_buffer.write( "\r\n", 2 );
}

void FormDataMessage::writeLine( const QString& line )
{
    if ( !line.isEmpty() ) {
        const char* data = line.toLatin1();
        m_buffer.write( data, qstrlen( data ) );
    }
    writeLine();
}

void FormDataMessage::writeRawBytes( const QByteArray& bytes )
{
    m_buffer.write( bytes );
}
