/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "definitionhelper.h"

#include <QApplication>
#include <QStringList>

using namespace WebIssues;

QString DefinitionHelper::typeName( DefinitionInfo::Type type )
{
    switch ( type ) {
        case DefinitionInfo::Text:
            return tr( "Text" );
        case DefinitionInfo::Enum:
            return tr( "Dropdown List" );
        case DefinitionInfo::Numeric:
            return tr( "Numeric" );
        case DefinitionInfo::DateTime:
            return tr( "Date & Time" );
        case DefinitionInfo::User:
            return tr( "User" );
    }
    return QString();
}

QString DefinitionHelper::metadataDetails( const DefinitionInfo& info )
{
    switch ( info.type() ) {
        case DefinitionInfo::Text:
            return textMetadataDetails( info );
        case DefinitionInfo::Enum:
            return enumMetadataDetails( info );
        case DefinitionInfo::Numeric:
            return numericMetadataDetails( info );
        case DefinitionInfo::DateTime:
            return dateTimeMetadataDetails( info );
        case DefinitionInfo::User:
            return userMetadataDetails( info );
    }
    return QString();
}

QString DefinitionHelper::textMetadataDetails( const DefinitionInfo& info )
{
    QStringList details;

    QVariant maxLength = info.metadata( "max-length" );
    if ( maxLength.isValid() )
        details.append( tr( "Max Length: %1" ).arg( maxLength.toString() ) );

    return details.join( "; " );
}

QString DefinitionHelper::enumMetadataDetails( const DefinitionInfo& info )
{
    QStringList details;

    QVariant editable = info.metadata( "editable" );
    if ( editable.isValid() && editable.toBool() )
        details.append( tr( "Editable" ) );

    QVariant items = info.metadata( "items" );
    if ( items.isValid() && items.toStringList().count() > 0 )
        details.append( tr( "Items: %1" ).arg( items.toStringList().join( ", " ) ) );

    return details.join( "; " );
}

QString DefinitionHelper::numericMetadataDetails( const DefinitionInfo& info )
{
    QStringList details;

    QVariant decimal = info.metadata( "decimal" );
    if ( decimal.isValid() && decimal.toInt() > 0 )
        details.append( tr( "Decimal places: %1" ).arg( decimal.toString() ) );

    QVariant minValue = info.metadata( "min-value" );
    if ( minValue.isValid() )
        details.append( tr( "Minimum: %1" ).arg( minValue.toString() ) );

    QVariant maxValue = info.metadata( "max-value" );
    if ( maxValue.isValid() )
        details.append( tr( "Maximum: %1" ).arg( maxValue.toString() ) );

    return details.join( "; " );
}

QString DefinitionHelper::dateTimeMetadataDetails( const DefinitionInfo& info )
{
    QStringList details;

    QVariant time = info.metadata( "time" );
    if ( time.isValid() && time.toBool() )
        details.append( tr( "With time" ) );

    return details.join( "; " );
}

QString DefinitionHelper::userMetadataDetails( const DefinitionInfo& info )
{
    QStringList details;

    QVariant members = info.metadata( "members" );
    if ( members.isValid() && members.toBool() )
        details.append( tr( "Members only" ) );

    return details.join( "; " );
}

QString DefinitionHelper::tr( const char* text )
{
    return qApp->translate( "WebIssues::DefinitionHelper", text );
}
