<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

define( 'VERSION', '0.8.4' );

if( !include_once( 'config/config.inc.php' ) )
    die( '<p><strong>Fatal Error:</strong> The configuration file <tt>config/config.inc.php</tt> does not exist.</p>' );

require_once( 'include/common.inc.php' );

define( 'SCRIPT', 'update.php' );

$page_titles = array(
    'config' => 'Configuration',
    'tables' => 'Data Tables'
);

$action = $_POST[ 'action' ];
$page = '';
$body = '';
$title = 'Update';

$result = wi_update_execute();

function wi_update_execute()
{
    global $action, $page, $body;
    global $config;

    $page = 'config';

    if ( !wi_check_config() )
        return false;

    $page = 'tables';

    if ( !wi_table_exists( 'server' ) ) {
        $body .= "<p><strong>ERROR:</strong> The data tables were not found. Use <a href=\"setup.php\">setup.php</a> if you want to create new tables.</p>\n";
        return false;
    }

    $query = "SELECT db_version FROM {server}";

    $server_row = wi_query_row( $query );

    $db_version = $server_row[ 'db_version' ];

    if ( version_compare( $db_version, VERSION, '>' ) ) {
        $body .= "<p><strong>ERROR:</strong> Current database version ($db_version) is newer than this script.</p>\n";
        return false;
    }

    if ( version_compare( $db_version, VERSION, '<' ) ) {
        if ( $action != 'tables' ) {
            $body .= "<p>Server is configured correctly. Current database version is $db_version.</p>\n";
            $body .= "<p>The database tables will be updated.</p>\n";
            return true;
        }

        $engine = $config[ 'db_engine' ];

        // 0.8.1 -> 0.8.2
        // add support for file storage

        if ( ( $engine == 'mysql' || $engine == 'mysqli' ) && $db_version == '0.8.1' ) {
            $query = "ALTER TABLE {files} MODIFY file_data longblob";
            wi_query( $query );
            $query = "ALTER TABLE {files} ADD file_storage tinyint(4) NOT NULL default '0'";
            wi_query( $query );
        }

        if ( $engine == 'pgsql' && $db_version == '0.8.1' ) {
            $query = "ALTER TABLE {files} ALTER COLUMN file_data DROP NOT NULL";
            wi_query( $query );
            $query = "ALTER TABLE {files} ADD COLUMN file_storage smallint NOT NULL default '0'";
            wi_query( $query );
        }

        // 0.8.2 -> 0.8.3
        // MySQL: set utf8_bin collation for some columns (or the BINARY attribute for MySQL 4.0)

        if ( ( $engine == 'mysql' || $engine == 'mysqli' ) && version_compare( $db_version, '0.8.2', '<=' ) ) {
            $tables = array(
                '{attr_types}' => array( 'attr_name' ),
                '{folders}' => array( 'folder_name' ),
                '{issue_types}' => array( 'type_name' ),
                '{projects}' => array( 'project_name' ),
                '{users}' => array( 'user_login', 'user_name' )
            );
            if ( $engine == 'mysqli' || version_compare( mysql_get_server_info(), '4.1', '>=' ) )
                $type = "varchar(40) COLLATE utf8_bin NOT NULL default ''";
            else
                $type = "varchar(255) BINARY NOT NULL default ''";
            foreach ( $tables as $table => $columns ) {
                $modify = array();
                foreach ( $columns as $column )
                    $modify[] = "MODIFY $column $type";
                $query = "ALTER TABLE $table " . implode( ", ", $modify );
                wi_query( $query );
            }
        }

        // 0.8.3 -> 0.8.4-beta1
        // add support for cron, preferences and notifications

        if ( version_compare( $db_version, '0.8.3', '<=' ) ) {
            switch ( $engine ) {
                case 'mysql':
                case 'mysqli':
                    $query = "ALTER TABLE {server} MODIFY db_version varchar(20) NOT NULL default ''";
                    wi_query( $query );
                    $query = "ALTER TABLE {server} ADD last_cron int(11)";
                    wi_query( $query );
                    break;
                case 'pgsql':
                    $query = "ALTER TABLE {server} ALTER COLUMN db_version TYPE varchar(20)";
                    wi_query( $query );
                    $query = "ALTER TABLE {server} ADD COLUMN last_cron integer";
                    wi_query( $query );
                    break;
                case 'mssql':
                    $query = "ALTER TABLE {server} ALTER COLUMN db_version varchar(20) NOT NULL";
                    wi_query( $query );
                    $query = "ALTER TABLE {server} ADD last_cron int";
                    wi_query( $query );
                    break;
            }

            $queries = wi_read_queries( '0.8.4-beta1' );

            foreach ( $queries as $query ) {
                $query = trim( $query );
                if ( !wi_query( $query ) ) {
                    $body .= "<p><strong>ERROR:</strong> Failed to create the database tables.</p>\n";
                    return false;
                }
            }
        }

        // --------------

        $query = "UPDATE {server} SET db_version = %s";
        wi_query( $query, VERSION );

        $body .= "<p>Database tables were updated successfully.</p>\n";
    }

    $page = '';

    $body .= "<p>This server is configured and working correctly.</p>\n";
    $body .= "<p>Use the WebIssues Client application to access the server.</p>\n";

    return true;
}

require_once( 'include/wizard.inc.php' );
