// Initializes the message dialog
function webdeveloper_initializeMessage()
{
    document.getElementById("webdeveloper-message").value = window.arguments[0];

    // If the second window argument is not set
    if(!window.arguments[1])
    {
        document.getElementById("webdeveloper-more-information").style.display = "none";
    }
}

// Loads the more information link in a new tab
function webdeveloper_moreInformation()
{
    var parentWindow = null;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            parentWindow = window.opener.opener;
        }
        else
        {
            parentWindow = window.opener;
        }
    }

    // If a parent window was found
    if(parentWindow)
    {
        // If the open in windows preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true))
        {
            var newTab = parentWindow.getBrowser().addTab(window.arguments[1]);

            // If the open tabs in background preference is not set or is set to false
            if(!webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
            {
                parentWindow.getBrowser().selectedTab = newTab;
            }
        }
        else
        {
            parentWindow.open(window.arguments[1]);
        }

        window.close();
    }
}