var webdeveloper_rulerDrag   = false;
var webdeveloper_rulerEndX   = 0;
var webdeveloper_rulerEndY   = 0;
var webdeveloper_rulerMove   = false;
var webdeveloper_rulerMoveX  = 0;
var webdeveloper_rulerMoveY  = 0;
var webdeveloper_rulerResize = false;
var webdeveloper_rulerStartX = 0;
var webdeveloper_rulerStartY = 0;

// Creates the ruler block
function webdeveloper_createRuler(ownerDocument)
{
    var containerElement = ownerDocument.createElement("div");
    var resizeElement    = ownerDocument.createElement("div");
    var rulerElement     = ownerDocument.createElement("div");

    resizeElement.setAttribute("id", "webdeveloper-ruler-north-west");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-north-east");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-south-east");
    containerElement.appendChild(resizeElement);

    resizeElement = ownerDocument.createElement("div");
    resizeElement.setAttribute("id", "webdeveloper-ruler-south-west");
    containerElement.appendChild(resizeElement);

    containerElement.setAttribute("id", "webdeveloper-ruler-container");
    rulerElement.appendChild(containerElement);

    rulerElement.setAttribute("id", "webdeveloper-ruler");
    webdeveloper_getDocumentBodyElement(ownerDocument).appendChild(rulerElement);
}

// Called when the ruler is deselected
function webdeveloper_deselectRuler(event)
{
    // If not moving the ruler
    if(!webdeveloper_rulerMove)
    {
        var xPosition = event.pageX;
        var yPosition = event.pageY;

        // If the X position is greater than the start X position
        if(xPosition > webdeveloper_rulerStartX)
        {
            webdeveloper_rulerEndX = xPosition;
        }
        else
        {
            webdeveloper_rulerEndX   = webdeveloper_rulerStartX;
            webdeveloper_rulerStartX = xPosition;
        }

        // If the Y position is greater than the start Y position
        if(yPosition > webdeveloper_rulerStartY)
        {
            webdeveloper_rulerEndY = yPosition;
        }
        else
        {
            webdeveloper_rulerEndY   = webdeveloper_rulerStartY;
            webdeveloper_rulerStartY = yPosition;
        }
    }

    webdeveloper_rulerDrag   = false;
    webdeveloper_rulerMove   = false;
    webdeveloper_rulerMoveX  = 0;
    webdeveloper_rulerMoveY  = 0;
    webdeveloper_rulerResize = false;

    webdeveloper_updateRulerEnd();
    webdeveloper_updateRulerStart();
}

// Displays a ruler
function webdeveloper_displayRuler(element)
{
    // If the page has frames
    if(webdeveloper_pageHasFrames())
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_framesNotSupported"));
    }
    else
    {
        var checked         = false;
        var contentDocument = webdeveloper_getContentDocument();
        var divElement      = null;

        // If the element is set
        if(element)
        {
            checked = element.getAttribute("checked");
        }

        webdeveloper_configureElement(document.getElementById("webdeveloper-ruler-toolbar"), "hidden", !checked);

        // If displaying a ruler
        if(checked)
        {
            webdeveloper_updateRulerEnd();
            webdeveloper_updateRulerStart();
            webdeveloper_createRuler(contentDocument);

            contentDocument.addEventListener("mousedown", webdeveloper_selectRuler, true);
            contentDocument.addEventListener("mousemove", webdeveloper_moveRuler, false);
            contentDocument.addEventListener("mouseup", webdeveloper_deselectRuler, true);
        }
        else
        {
            var rulerHeightElement = document.getElementById("webdeveloper-ruler-height");
            var rulerWidthElement  = document.getElementById("webdeveloper-ruler-width");

            webdeveloper_removeRuler(contentDocument);

            // Try to remove the event listener
            try
            {
                contentDocument.removeEventListener("mousedown", webdeveloper_selectRuler, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                contentDocument.removeEventListener("mousemove", webdeveloper_moveRuler, false);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                contentDocument.removeEventListener("mouseup", webdeveloper_deselectRuler, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // If the ruler height element is set
            if(rulerHeightElement)
            {
                rulerHeightElement.value = "";
            }

            // If the ruler width element is set
            if(rulerWidthElement)
            {
                rulerWidthElement.value = "";
            }

            webdeveloper_rulerDrag   = false;
            webdeveloper_rulerEndX   = 0;
            webdeveloper_rulerEndY   = 0;
            webdeveloper_rulerMove   = false;
            webdeveloper_rulerMoveX  = 0;
            webdeveloper_rulerMoveY  = 0;
            webdeveloper_rulerResize = false;
            webdeveloper_rulerStartX = 0;
            webdeveloper_rulerStartY = 0;
        }

        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_ruler.css", "webdeveloper-display-ruler");
    }
}

// Called when the ruler is moved
function webdeveloper_moveRuler(event)
{
    var element = event.target;

    // If the element is set
    if(element)
    {
        var ownerDocument = element.ownerDocument;

        // If the element has an owner document
        if(ownerDocument)
        {
            var rulerElement = ownerDocument.getElementById("webdeveloper-ruler");

            // If the ruler element is set
            if(rulerElement)
            {
                var xPosition = event.pageX;
                var yPosition = event.pageY;

                // If the ruler is being dragged or resized
                if(webdeveloper_rulerDrag || webdeveloper_rulerResize)
                {
                    var height             = 0;
                    var rulerHeightElement = document.getElementById("webdeveloper-ruler-height");
                    var rulerWidthElement  = document.getElementById("webdeveloper-ruler-width");
                    var width              = 0;

                    webdeveloper_rulerEndX = xPosition;
                    webdeveloper_rulerEndY = yPosition;

                    // If the start x position is greater than the end x position
                    if(webdeveloper_rulerStartX > webdeveloper_rulerEndX)
                    {
                        width = webdeveloper_rulerStartX - webdeveloper_rulerEndX;

                        rulerElement.style.left = xPosition + "px";
                    }
                    else
                    {
                        width = webdeveloper_rulerEndX - webdeveloper_rulerStartX;

                        rulerElement.style.left = webdeveloper_rulerStartX + "px";
                    }

                    // If the start y position is greater than the end y position
                    if(webdeveloper_rulerStartY > webdeveloper_rulerEndY)
                    {
                        height = webdeveloper_rulerStartY - webdeveloper_rulerEndY;

                        rulerElement.style.top = webdeveloper_rulerEndY + "px";
                    }
                    else
                    {
                        height = webdeveloper_rulerEndY - webdeveloper_rulerStartY;

                        rulerElement.style.top = webdeveloper_rulerStartY + "px";
                    }

                    rulerElement.style.height = height + "px";
                    rulerElement.style.width  = width + "px";

                    // If the ruler height element is set
                    if(rulerHeightElement)
                    {
                        rulerHeightElement.value = height;
                    }

                    // If the ruler width element is set
                    if(rulerWidthElement)
                    {
                        rulerWidthElement.value = width;
                    }
                }
                else if(webdeveloper_rulerMove)
                {
                    var newXPosition = xPosition - webdeveloper_rulerMoveX;
                    var newYPosition = yPosition - webdeveloper_rulerMoveY;

                    rulerElement.style.left = newXPosition + "px";
                    rulerElement.style.top  = newYPosition + "px";

                    webdeveloper_rulerEndX   = newXPosition + rulerElement.clientWidth;
                    webdeveloper_rulerEndY   = newYPosition + rulerElement.clientHeight;
                    webdeveloper_rulerStartX = newXPosition;
                    webdeveloper_rulerStartY = newYPosition;
                }

                webdeveloper_updateRulerEnd();
                webdeveloper_updateRulerStart();
            }
        }
    }
}

// Remove the ruler from the document
function webdeveloper_removeRuler(ownerDocument)
{
    webdeveloper_removeElement(ownerDocument.getElementById("webdeveloper-ruler"));
}

// Called when the ruler is selected
function webdeveloper_selectRuler(event)
{
    // If the click was not a right click
    if(event.button != 2)
    {
        var element = event.target;

        // If the element is set
        if(element)
        {
            var elementName   = element.tagName;
            var ownerDocument = element.ownerDocument;

            // If the element has a name and it is not scrollbar and it has an owner document
            if(elementName && elementName != "scrollbar" && ownerDocument)
            {
                var rulerElement = ownerDocument.getElementById("webdeveloper-ruler");
                var xPosition    = event.pageX;
                var yPosition    = event.pageY;

                // If the ruler element is set
                if(rulerElement)
                {
                    // If element is the container element
                    if(element == ownerDocument.getElementById("webdeveloper-ruler-container"))
                    {
                        webdeveloper_rulerMove  = true;
                        webdeveloper_rulerMoveX = xPosition - rulerElement.offsetLeft;
                        webdeveloper_rulerMoveY = yPosition - rulerElement.offsetTop;
                    }
                    else if(element == ownerDocument.getElementById("webdeveloper-ruler-north-east"))
                    {
                        webdeveloper_rulerResize = true;
                        webdeveloper_rulerStartX = rulerElement.offsetLeft;
                        webdeveloper_rulerStartY = rulerElement.offsetTop + rulerElement.clientHeight;
                    }
                    else if(element == ownerDocument.getElementById("webdeveloper-ruler-north-west"))
                    {
                        webdeveloper_rulerResize = true;
                        webdeveloper_rulerStartX = rulerElement.offsetLeft + rulerElement.clientWidth;
                        webdeveloper_rulerStartY = rulerElement.offsetTop + rulerElement.clientHeight;
                    }
                    else if(element == ownerDocument.getElementById("webdeveloper-ruler-south-east"))
                    {
                        webdeveloper_rulerResize = true;
                        webdeveloper_rulerStartX = rulerElement.offsetLeft;
                        webdeveloper_rulerStartY = rulerElement.offsetTop;
                    }
                    else if(element == ownerDocument.getElementById("webdeveloper-ruler-south-west"))
                    {
                        webdeveloper_rulerResize = true;
                        webdeveloper_rulerStartX = rulerElement.offsetLeft + rulerElement.clientWidth;
                        webdeveloper_rulerStartY = rulerElement.offsetTop;
                    }
                    else
                    {
                        webdeveloper_rulerDrag   = true;
                        webdeveloper_rulerEndX   = 0;
                        webdeveloper_rulerEndY   = 0;
                        webdeveloper_rulerStartX = xPosition;
                        webdeveloper_rulerStartY = yPosition;

                        webdeveloper_updateRulerEnd();
                        webdeveloper_updateRulerStart();
                    }
                }
            }
        }

        event.stopPropagation();
        event.preventDefault();
    }
}

// Update the ruler end information
function webdeveloper_updateRulerEnd()
{
    var endXElement = document.getElementById("webdeveloper-ruler-end-x");
    var endYElement = document.getElementById("webdeveloper-ruler-end-y");

    // If the end X element is set
    if(endXElement)
    {
        endXElement.value = webdeveloper_rulerEndX;
    }

    // If the end Y element is set
    if(endYElement)
    {
        endYElement.value = webdeveloper_rulerEndY;
    }
}

// Update the ruler height
function webdeveloper_updateRulerHeight(element)
{
    var height       = element.value;
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the height is empty or not a number or less than zero
    if(!height || parseInt(height) != height || height <= 0)
    {
        webdeveloper_error(stringBundle.getString("webdeveloper_invalidHeight"));
    }
    else
    {
        var rulerElement = webdeveloper_getContentDocument().getElementById("webdeveloper-ruler");

        // If the ruler element is set
        if(rulerElement)
        {
            height                    = parseInt(height);
            rulerElement.style.height = height + "px";
            webdeveloper_rulerEndY    = webdeveloper_rulerStartY + height;

            webdeveloper_updateRulerEnd();
        }
    }
}

// Update the ruler start information
function webdeveloper_updateRulerStart()
{
    var startXElement = document.getElementById("webdeveloper-ruler-start-x");
    var startYElement = document.getElementById("webdeveloper-ruler-start-y");

    // If the start X element is set
    if(startXElement)
    {
        startXElement.value = webdeveloper_rulerStartX;
    }

    // If the start Y element is set
    if(startYElement)
    {
        startYElement.value = webdeveloper_rulerStartY;
    }
}

// Update the ruler width
function webdeveloper_updateRulerWidth(element)
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var width        = element.value;

    // If the width is empty or not a number or less than zero
    if(!width || parseInt(width) != width || width <= 0)
    {
        webdeveloper_error(stringBundle.getString("webdeveloper_invalidWidth"));
    }
    else
    {
        var rulerElement = webdeveloper_getContentDocument().getElementById("webdeveloper-ruler");

        // If the ruler element is set
        if(rulerElement)
        {
            width                    = parseInt(width);
            rulerElement.style.width = width + "px";
            webdeveloper_rulerEndX   = webdeveloper_rulerStartX + width;

            webdeveloper_updateRulerEnd();
        }
    }
}