/*
 * $Id: serv_func.c 7371 2009-04-18 12:45:35Z dothebart $
 */

#include "webcit.h"
#include "webserver.h"


void DeleteServInfo(ServInfo **FreeMe)
{
	if (*FreeMe == NULL)
		return;
	FreeStrBuf(&(*FreeMe)->serv_nodename);
	FreeStrBuf(&(*FreeMe)->serv_humannode);
	FreeStrBuf(&(*FreeMe)->serv_fqdn);
	FreeStrBuf(&(*FreeMe)->serv_software);
	FreeStrBuf(&(*FreeMe)->serv_bbs_city);
	FreeStrBuf(&(*FreeMe)->serv_sysadm);
	FreeStrBuf(&(*FreeMe)->serv_moreprompt);
	FreeStrBuf(&(*FreeMe)->serv_default_cal_zone);
	FreeStrBuf(&(*FreeMe)->serv_svn_revision);
	free(*FreeMe);
	*FreeMe = NULL;
}

/*
 * get info about the server we've connected to
 *
 * browser_host		the citadell we want to connect to
 * user_agent		which browser uses our client?
 */
ServInfo *get_serv_info(StrBuf *browser_host, char *user_agent)
{
	ServInfo *info;
	StrBuf *Buf;
	char buf[SIZ];
	int a;

	/** Tell the server what kind of client is connecting */
	serv_printf("IDEN %d|%d|%d|%s|%s",
		    DEVELOPER_ID,
		    CLIENT_ID,
		    CLIENT_VERSION,
		    user_agent,
		    ChrPtr(browser_host)
	);
	serv_getln(buf, sizeof buf);

	/** Tell the server what kind of richtext we prefer */
	serv_puts("MSGP text/calendar|text/html|text/plain");
	serv_getln(buf, sizeof buf);

	/*
	 * Tell the server that when we save a calendar event, we
	 * want invitations to be generated by the Citadel server
	 * instead of by the client.
	 */
	serv_puts("ICAL sgi|1");
	serv_getln(buf, sizeof buf);

	/** Now ask the server to tell us a little bit about itself... */
	serv_puts("INFO");
	serv_getln(buf, sizeof buf);
	if (buf[0] != '1')
		return NULL;

	info = (ServInfo*)malloc(sizeof(ServInfo));
	memset(info, 0, sizeof(ServInfo));
	a = 0;
	Buf = NewStrBuf();
	while (StrBuf_ServGetln(Buf), (strcmp(ChrPtr(Buf), "000")!= 0)) {
/*		lprintf (1, "a: %d [%s]", a, ChrPtr(Buf));*/
		switch (a) {
		case 0:
			info->serv_pid = StrToi(Buf);
			WC->ctdl_pid = info->serv_pid;
			break;
		case 1:
			info->serv_nodename = NewStrBufDup(Buf);
			break;
		case 2:
			info->serv_humannode = NewStrBufDup(Buf);
			break;
		case 3:
			info->serv_fqdn = NewStrBufDup(Buf);
			break;
		case 4:
			info->serv_software = NewStrBufDup(Buf);
			break;
		case 5:
			info->serv_rev_level = StrToi(Buf);
			break;
		case 6:
			info->serv_bbs_city = NewStrBufDup(Buf);
			break;
		case 7:
			info->serv_sysadm = NewStrBufDup(Buf);
			break;
		case 9:
			info->serv_moreprompt = NewStrBufDup(Buf);
			break;
		case 14:
			info->serv_supports_ldap = StrToi(Buf);
			break;
		case 15:
			info->serv_newuser_disabled = StrToi(Buf);
			break;
		case 16:
			info->serv_default_cal_zone = NewStrBufDup(Buf);
			break;
		case 20:
			info->serv_supports_sieve = StrToi(Buf);
			break;
		case 21:
			info->serv_fulltext_enabled = StrToi(Buf);
			break;
		case 22:
			info->serv_svn_revision = NewStrBufDup(Buf);
			break;
		case 23:
			info->serv_supports_openid = StrToi(Buf);
			break;
		}
		++a;
	}
	FreeStrBuf(&Buf);
	return info;
}



/**
 *  Read Citadel variformat text and spit it out as HTML.
 *  align html align string
 */
inline void fmout(char *align)
{
	_fmout(WC->WBuf, align);
}

void _fmout(StrBuf *Target, char *align)
{
	int intext = 0;
	int bq = 0;
	char buf[SIZ];

	StrBufAppendPrintf(Target, "<div align=%s>\n", align);
	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {

		if ((intext == 1) && (isspace(buf[0]))) {
			wprintf("<br />");
		}
		intext = 1;

		/**
		 * Quoted text should be displayed in italics and in a
		 * different colour.  This code understands Citadel-style
		 * " >" quotes and will convert to <BLOCKQUOTE> tags.
		 */
		if ((bq == 0) && (!strncmp(buf, " >", 2))) {
			StrBufAppendBufPlain(Target, HKEY("<BLOCKQUOTE>"), 0);
			bq = 1;
		} else if ((bq == 1) && (strncmp(buf, " >", 2))) {
			StrBufAppendBufPlain(Target, HKEY("</BLOCKQUOTE>"), 0);
			bq = 0;
		}
		if ((bq == 1) && (!strncmp(buf, " >", 2))) {
			strcpy(buf, &buf[2]);
		}
		/** Activate embedded URL's */
		url(buf, sizeof(buf));

		escputs(buf);
		StrBufAppendBufPlain(Target, HKEY("\n"), 0);
	}
	if (bq == 1) {
		wprintf("</I>");
	}
	wprintf("</div><br />\n");
}

void FmOut(StrBuf *Target, char *align, StrBuf *Source)
{
	const char *ptr, *pte;
	const char *BufPtr = NULL;
	StrBuf *Line = NewStrBuf();
	StrBuf *Line1 = NewStrBuf();
	StrBuf *Line2 = NewStrBuf();
	int bn = 0;
	int bq = 0;
	int i, n, done = 0;
	long len;
	int intext = 0;

	StrBufAppendPrintf(Target, "<div class=\"fmout-%s\">\n", align);
	while ((n = StrBufSipLine(Line, Source, &BufPtr), n >= 0) && !done)
	{
		done = n == 0;
		bq = 0;
		i = 0;
		ptr = ChrPtr(Line);
		len = StrLength(Line);
		pte = ptr + len;

		if ((intext == 1) && (isspace(*ptr))) {
			StrBufAppendBufPlain(Target, HKEY("<br>"), 0);
		}
		intext = 1;
		if (isspace(*ptr)) while ((ptr < pte) &&
		       ((*ptr == '>') ||
			isspace(*ptr)))
		{
			if (*ptr == '>')
				bq++;
			ptr ++;
			i++;
		}

		/**
		 * Quoted text should be displayed in italics and in a
		 * different colour.  This code understands Citadel-style
		 * " >" quotes and will convert to <BLOCKQUOTE> tags.
		 */
		if (i > 0) StrBufCutLeft(Line, i);
		

		for (i = bn; i < bq; i++)				
			StrBufAppendBufPlain(Target, HKEY("<blockquote>"), 0);
		for (i = bq; i < bn; i++)				
			StrBufAppendBufPlain(Target, HKEY("</blockquote>"), 0);
		bn = bq;

		if (StrLength(Line) == 0)
			continue;
		/** Activate embedded URL's */
		UrlizeText(Line1, Line, Line2);

		StrEscAppend(Target, Line1, NULL, 0, 0);

		StrBufAppendBufPlain(Target, HKEY("\n"), 0);
	}
	for (i = 0; i < bn; i++)				
		StrBufAppendBufPlain(Target, HKEY("</blockquote>"), 0);
	StrBufAppendBufPlain(Target, HKEY("</div><br>\n"), 0);
	FreeStrBuf(&Line);
	FreeStrBuf(&Line1);
	FreeStrBuf(&Line2);
}




/**
 *  Read Citadel variformat text and spit it out as HTML in a form
 * suitable for embedding in another message (forward/quote).
 * (NO LINEBREAKS ALLOWED HERE!)
 */
void pullquote_fmout(void) {
	int intext = 0;
	int bq = 0;
	char buf[SIZ];

	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {

		if ((intext == 1) && (isspace(buf[0]))) {
			wprintf("<br />");
		}
		intext = 1;

		/**
		 * Quoted text should be displayed in italics and in a
		 * different colour.  This code understands Citadel-style
		 * " >" quotes and will convert to <BLOCKQUOTE> tags.
		 */
		if ((bq == 0) && (!strncmp(buf, " >", 2))) {
			wprintf("<BLOCKQUOTE>");
			bq = 1;
		} else if ((bq == 1) && (strncmp(buf, " >", 2))) {
			wprintf("</BLOCKQUOTE>");
			bq = 0;
		}
		if ((bq == 1) && (!strncmp(buf, " >", 2))) {
			strcpy(buf, &buf[2]);
		}

		msgescputs(buf);
	}
	if (bq == 1) {
		wprintf("</I>");
	}
}




/**
 *  Transmit message text (in memory) to the server.
 *
 *  ptr Pointer to the message being transmitted
 */
void text_to_server(char *ptr)
{
	char buf[256];
	int ch, a, pos, len;

	pos = 0;
	buf[0] = 0;

	while (ptr[pos] != 0) {
		ch = ptr[pos++];
		if (ch == 10) {
			len = strlen(buf);
			while ( (isspace(buf[len - 1]))
				&& (buf[0] !=  '\0') 
				&& (buf[1] !=  '\0') )
				buf[--len] = 0;
			serv_puts(buf);
			buf[0] = 0;
			if (ptr[pos] != 0) strcat(buf, " ");
		} else {
			a = strlen(buf);
			buf[a + 1] = 0;
			buf[a] = ch;
			if ((ch == 32) && (strlen(buf) > 200)) {
				buf[a] = 0;
				serv_puts(buf);
				buf[0] = 0;
			}
			if (strlen(buf) > 250) {
				serv_puts(buf);
				buf[0] = 0;
			}
		}
	}
	serv_puts(buf);
}


/**
 *  Transmit message text (in memory) to the server,
 *        converting to Quoted-Printable encoding as we go.
 *
 *  ptr Pointer to the message being transmitted
 */
void text_to_server_qp(char *ptr)
{
	unsigned char ch, buf[256];
	int pos;
	int output_len = 0;

	pos = 0;
	buf[0] = 0;
	output_len = 0;

	while (ptr[pos] != 0) {
		ch = (unsigned char)(ptr[pos++]);

		if (ch == 13) {
			/* ignore carriage returns */
		}
		else if (ch == 10) {
			/* hard line break */
			if (output_len > 0) {
				if (isspace(buf[output_len-1])) {
					sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
					output_len += 2;
				}
			}
			buf[output_len++] = 0;
			serv_puts((char *)buf);
			output_len = 0;
		}
		else if (ch == 9) {
			buf[output_len++] = ch;
		}
		else if ( (ch >= 32) && (ch <= 60) ) {
			buf[output_len++] = ch;
		}
		else if ( (ch >= 62) && (ch <= 126) ) {
			buf[output_len++] = ch;
		}
		else {
			sprintf((char *)&buf[output_len], "=%02X", ch);
			output_len += 3;
		}
		
		if (output_len > 72) {
			/* soft line break */
			if (isspace(buf[output_len-1])) {
				sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
				output_len += 2;
			}
			buf[output_len++] = '=';
			buf[output_len++] = 0;
			serv_puts((char *)buf);
			output_len = 0;
		}
	}

	/* end of data - transmit anything that's left */
	if (output_len > 0) {
		if (isspace(buf[output_len-1])) {
			sprintf((char *)&buf[output_len-1], "=%02X", buf[output_len-1]);
			output_len += 2;
		}
		buf[output_len++] = 0;
		serv_puts((char *)buf);
		output_len = 0;
	}
}




/**
 *  translate server message output to text
 * (used for editing room info files and such)
 */
void server_to_text()
{
	char buf[SIZ];

	int count = 0;

	while (serv_getln(buf, sizeof buf), strcmp(buf, "000")) {
		if ((buf[0] == 32) && (count > 0)) {
			wprintf("\n");
		}
		wprintf("%s", buf);
		++count;
	}
}



/**
 * Read binary data from server into memory using a series of
 * server READ commands.
 * \return the read content as StrBuf
 */
int read_server_binary(StrBuf *Ret, size_t total_len) 
{
	char buf[SIZ];
	size_t bytes = 0;
	size_t thisblock = 0;
	StrBuf *Buf;
	
	Buf = NewStrBuf();
	if (Ret == NULL)
	    return -1;

	while (bytes < total_len) {
		thisblock = 4095;
		if ((total_len - bytes) < thisblock) {
			thisblock = total_len - bytes;
			if (thisblock == 0) {
				FlushStrBuf(Ret); 
				FreeStrBuf(&Buf);
				return -1; 
			}
		}
		serv_printf("READ %d|%d", (int)bytes, (int)thisblock);
		if (StrBuf_ServGetln(Buf) > 0)
		{
			if (GetServerStatus(Buf, NULL) == 6)
			{
			    StrBufCutLeft(Buf, 4); /*/ TODO : thisblock = (size_t)atoi(&buf[4]); */
			    thisblock = StrTol(Buf);
			    if (!WC->connected) {
				    FlushStrBuf(Ret); 
				    FreeStrBuf(&Buf); 
				    return -1; 
			    }
			    StrBuf_ServGetBLOB(Ret, thisblock);
			    bytes += thisblock;
		    }
		    else {
			    FreeStrBuf(&Buf);
			    lprintf(3, "Error: %s\n", &buf[4]);
			    return -1;
		    }
		}
	}
	FreeStrBuf(&Buf);
	return StrLength(Ret);
}


/**
 *  Read text from server, appending to a string buffer until the
 * usual 000 terminator is found.  Caller is responsible for freeing
 * the returned pointer.
 */
int read_server_text(StrBuf *Buf, long *nLines)
{
	wcsession *WCC = WC;
	long nRead;
	long nTotal = 0;
	long nlines;
	
	nlines = 0;
	while ((WCC->serv_sock!=-1) &&
	       (nRead = StrBuf_ServGetln(Buf), (nRead >= 0) ))
	{
		if (strcmp(ChrPtr(Buf) + nTotal, "000") != 0) {
			StrBufCutRight(Buf, nRead);
			break;
		}
		nTotal += nRead;
		nlines ++;
	}

	*nLines = nlines;
	return nTotal;
}






int GetServerStatus(StrBuf *Line, long* FullState)
{
	if (FullState != NULL)
		*FullState = StrTol(Line);
	return ChrPtr(Line)[0] - 48;
}


void tmplput_serv_ip(StrBuf *Target, WCTemplputParams *TP)
{
	StrBufAppendPrintf(Target, "%d", WC->ctdl_pid);
}

void tmplput_serv_nodename(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendTemplate(Target, TP, WCC->serv_info->serv_nodename, 0);
}

void tmplput_serv_humannode(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendTemplate(Target, TP, WCC->serv_info->serv_humannode, 0);
}

void tmplput_serv_fqdn(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendTemplate(Target, TP, WCC->serv_info->serv_fqdn, 0);
}

void tmplput_serv_software(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendTemplate(Target, TP, WCC->serv_info->serv_software, 0);
}

void tmplput_serv_rev_level(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendPrintf(Target, "%d.%02d",
			    WCC->serv_info->serv_rev_level / 100,
			    WCC->serv_info->serv_rev_level % 100);
}
int conditional_serv_newuser_disabled(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return 0;
	return WCC->serv_info->serv_newuser_disabled != 0;
}
int conditional_serv_supports_openid(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return 0;
	return WCC->serv_info->serv_supports_openid != 0;
}

void tmplput_serv_bbs_city(StrBuf *Target, WCTemplputParams *TP)
{
	wcsession *WCC = WC;
	if (WCC->serv_info == NULL)
		return;
	StrBufAppendTemplate(Target, TP, WC->serv_info->serv_bbs_city, 0);
}


void tmplput_mesg(StrBuf *Target, WCTemplputParams *TP)
{
	int n = 0;
	int Done = 0;
	StrBuf *Line;
	StrBuf *Buf;

	Buf = NewStrBuf();
	Line = NewStrBuf();
	serv_printf("MESG %s", TP->Tokens->Params[0]->Start);

	StrBuf_ServGetln(Line);
	if (GetServerStatus(Line, NULL) == 1) {
		while (!Done &&  (StrBuf_ServGetln(Line)>=0)) {
			if ( (StrLength(Line)==3) && 
			     !strcmp(ChrPtr(Line), "000")) 
				Done = 1;
			else
			{
				if (n > 0)
					StrBufAppendBufPlain(Buf, "\n", 1, 0);
				StrBufAppendBuf(Buf, Line, 0);
			}
			n++;
		}
	
		FlushStrBuf(Line);
		FmOut(Line, "center", Buf);
		StrBufAppendTemplate(Target, TP, Line, 1);
	}
	FreeStrBuf(&Buf);
	FreeStrBuf(&Line);
}

void 
InitModule_SERVFUNC
(void)
{

	RegisterConditional(HKEY("COND:SERV:OPENID"), 2, conditional_serv_supports_openid, CTX_NONE);
	RegisterConditional(HKEY("COND:SERV:NEWU"), 2, conditional_serv_newuser_disabled, CTX_NONE);
	RegisterNamespace("SERV:PID", 0, 0, tmplput_serv_ip, CTX_NONE);
	RegisterNamespace("SERV:NODENAME", 0, 1, tmplput_serv_nodename, CTX_NONE);
	RegisterNamespace("SERV:HUMANNODE", 0, 1, tmplput_serv_humannode, CTX_NONE);
	RegisterNamespace("SERV:FQDN", 0, 1, tmplput_serv_fqdn, CTX_NONE);
	RegisterNamespace("SERV:SOFTWARE", 0, 1, tmplput_serv_software, CTX_NONE);
	RegisterNamespace("SERV:REV_LEVEL", 0, 0, tmplput_serv_rev_level, CTX_NONE);
	RegisterNamespace("SERV:BBS_CITY", 0, 1, tmplput_serv_bbs_city, CTX_NONE);
	RegisterNamespace("SERV:MESG", 1, 2, tmplput_mesg, CTX_NONE);
/*TODO //	RegisterNamespace("SERV:LDAP_SUPP", 0, 0, tmplput_serv_ldap_enabled, 0); */
}

/*@}*/
