/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.util.Calendar;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils {
    public static String xmlNodeGetValue(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n > 1) {
            System.err.println("  Error: length of node=" + n + " for tag <" + node.getNodeName() + ">");
        }
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            return node2.getNodeValue();
        }
        return null;
    }

    public static String xmlNodeGetAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Attr attr;
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeType() != 2 || !string.equalsIgnoreCase((attr = (Attr)node2).getName())) continue;
            return attr.getValue();
        }
        return null;
    }

    public static String getError(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = document.getElementsByTagName("error");
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(Utils.xmlNodeGetValue(node));
        }
        return stringBuffer.toString();
    }

    public static String CalendarToYYYYMMDD(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(calendar.get(1));
        if (calendar.get(2) + 1 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(2) + 1);
        if (calendar.get(5) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(calendar.get(5));
        return stringBuffer.toString();
    }

    public static Calendar YYYYMMDDToCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        int n = Integer.parseInt(string.substring(0, 3));
        int n2 = Integer.parseInt(string.substring(4, 5));
        int n3 = Integer.parseInt(string.substring(6, 7));
        calendar.set(n, n2, n3);
        return calendar;
    }

    public static Calendar startOfWeek(Calendar calendar, boolean bl) {
        int n = bl ? 1 : 2;
        Calendar calendar2 = (Calendar)calendar.clone();
        while (calendar2.get(7) != n) {
            calendar2.add(5, -1);
        }
        return calendar2;
    }

    public static Calendar endOfWeek(Calendar calendar, boolean bl) {
        int n = bl ? 7 : 1;
        Calendar calendar2 = (Calendar)calendar.clone();
        while (calendar2.get(7) != n) {
            calendar2.add(5, 1);
        }
        return calendar2;
    }
}

