/*
    Warzone 2100 Lobbyserver, serves as a meeting place to set up games
    Copyright (C) 2007  Giel van Schijndel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    $Revision: 1315 $
    $Id: lobby_iterator.cpp 1315 2007-05-21 11:27:58Z muggenhor $
    $HeadURL: svn://svn.gna.org/svn/warzone/trunk/tools/lobbyserver_cpp/src/lobby/lobby_iterator.cpp $
*/

#include "lobby_iterator.hpp"

GameLobby::iterator_interface::iterator_interface(const GameLobby& lobby) :
    _lobby(lobby),
    lock(_lobby._mutex)
{
}

GameLobby::iterator_interface::const_iterator GameLobby::iterator_interface::begin() const
{
    return const_iterator(*this, _lobby._games.begin());
}

GameLobby::iterator_interface::const_iterator GameLobby::iterator_interface::end() const
{
    return const_iterator(*this, _lobby._games.end());
}

std::size_t GameLobby::iterator_interface::size() const
{
    return _lobby._games.size();
}

GameLobby::iterator_interface::const_iterator::const_iterator(const iterator_interface& interface, const std::list<GAMESTRUCT>::const_iterator& iter) :
    _interface(interface),
    _iter(iter)
{
}

bool GameLobby::iterator_interface::const_iterator::operator==(const const_iterator& i) const
{
    if (&_interface._lobby != &i._interface._lobby)
        return false;

    return _iter == i._iter;
}

bool GameLobby::iterator_interface::const_iterator::operator!=(const const_iterator& i) const
{
    return !(*this == i);
}

void GameLobby::iterator_interface::const_iterator::operator++()
{
    ++_iter;
}

GameLobby::iterator_interface::const_reference GameLobby::iterator_interface::const_iterator::operator*() const
{
    return *_iter;
}
