#ifndef FLAT_STATE_H
#define FLAT_STATE_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "State.h"

/** The abstract base class FlatState.
	 
    This class provides an interface for a default implementation of a
    state class. The following is an example of the inteded use of this
    class:

    \begin{verbatim}
    class ApplicationState : public FlatState{
      int someData;
    
      // don't need to define copyState() as application is satisfied
      // with the one defined in FlatState
    
      // but we HAVE to define getSize()
      unsigned int getSize() const { return sizeof(ApplicationState); }
    }
    \end{verbatim}
*/
class FlatState : public State {
public:
  /**@name Public Class Methods of FlatState */
  //@{

  /// Destructor.
  virtual ~FlatState();
  
  /** Return size of the state.

      This is a pure virtual virtual function that has to be overridden.

      @return Return size of the state.  
  */
  virtual const int getSize() const = 0;

   /** Make a bitwise copy of a given state.

       See State::\Ref{State::copyState}.
       
       @param state is a pointer to the state to be copied.
   */
   void copyState(const State* state);

   //@} // End of Public Class Methods of FlatState.

protected:
  /**@name Protected Class Methods of FlatState */
  //@{

  /// Default Constructor.
  FlatState();

  //@} // End of Protected Class Methods of FlatState
};

#endif
