#include "DeserializerManager.h"

void 
DeserializerManager::registerDeserializer( const string &dataType, 
					   deserializeFunc functionPtr ){
  deserializerMap.insert( dataType, functionPtr );
}

deserializeFunc 
DeserializerManager::findDeserializer( const string &dataType ){
  return deserializerMap.find( dataType );
}


DeserializerManager *
DeserializerManager::instance(){
  static DeserializerManager *instance = new DeserializerManager();

  return instance;
}


