#ifndef COMMUNICATING_ENTITY_H
#define COMMUNICATING_ENTITY_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "KernelMessage.h"

/** The CommunicatingEntity abstract base class.

    Any class that wants to receive kernel messages from the
    communication manager must be derived from this abstract
    class. This way, the child class must implement the
    "registerWithCommunicationManager" and "receiveKernelMessage"
    methods.

*/
class CommunicatingEntity {
public:

   /**@name Public Class Methods of CommunicatingEntity. */
   //@{
   
   /// Destructor.
   virtual ~CommunicatingEntity(){};

   /** Method the communication mgr calls to deliver a message.

       This is a pure virtual function that has to be overriden.

       @param msg Pointer to the received message.
   */
   virtual void receiveKernelMessage(KernelMessage *msg) = 0;
   //@} // End of Public Class Methods of CommunicatingEntity.
   
protected:
   /**@name Protected Class Methods of CommunicatingEntity. */
   //@{

   /// Default Constructor.
   CommunicatingEntity(){};
   //@} // End of Protected Class Methods of CommunicatingEntity.
};

#endif
