// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: SingleLinkedList.cpp
// 
//---------------------------------------------------------------------------

#include "SingleLinkedList.h"
#include <algorithm>
#include <functional>

using std::for_each;
using std::unary_function;

SingleLinkedList::SingleLinkedList(){
  processedEvents = new vector<const Event *>;
}

SingleLinkedList::~SingleLinkedList(){
  cleanUp();
  delete processedEvents;
}

void
SingleLinkedList::insert( const Event *event ){
  push(event); // insert this guy into the queue
}

const Event *
SingleLinkedList::getEvent(){
  const Event *retval = top(); // have a look at the top element
  processedEvents->push_back(retval); // store this guy for deletion
  pop(); // remove this guy from the queue
  return retval;
}

const Event *
SingleLinkedList::peekEvent(){
  if(!empty()){
    return top(); // have a look at the top element
  }
  else {
    return 0;
  }
}

class DeleteEvent {
public:
  void operator()( const Event *toDelete ){
    delete toDelete;
  }
};

void
SingleLinkedList::cleanUp(){
  for_each( processedEvents->begin(),
	    processedEvents->end(),
	    DeleteEvent() );

  processedEvents->resize(0);
}

const string &
SingleLinkedList::getType() {
  static const string singleLinkedListType = "SingleLinkedList";
  return singleLinkedListType;
}
