// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: OutputManagerFactory.cpp
// 
//---------------------------------------------------------------------------

#include "Event.h"
#include "SimulationObject.h"
#include "OutputManager.h"
#include "AggressiveOutputManager.h"
#include "OutputManagerFactory.h"
#include "SimulationConfiguration.h"
#include "TimeWarpSimulationManager.h"
#include <clutils/ConfigurationChoice.h>
#include <clutils/Debug.h>
#include <clutils/StringUtilities.h>

using std::cerr;
using std::endl;

OutputManagerFactory::OutputManagerFactory(){}

OutputManagerFactory::~OutputManagerFactory(){}

// configure this  factory to instantiate the chosen output manager
Configurable *
OutputManagerFactory::allocate( SimulationConfiguration &configuration,
				Configurable *parent ) const {

  Configurable *retval = 0;
  TimeWarpSimulationManager *mySimulationManager = 
    dynamic_cast<TimeWarpSimulationManager *>( parent );
  ASSERT( mySimulationManager != 0 );

  // the following cases are possible:

  // (1) AggressiveOutputManager 
  // (2) LazyOutputManager
  // (3) AdaptiveOutputManager
  if( configuration.outputManagerIs( "AGGRESSIVE" ) ){
    retval = new AggressiveOutputManager( mySimulationManager );
    clutils::debug << "an Aggressive Output Manager" << endl;
  }
  else if( configuration.outputManagerIs( "LAZY" ) ){
    abort();
  }
  else if( configuration.outputManagerIs( "ADAPTIVE" ) ){
    abort();
  }
  else {
    const string error = "Unknown OutputManager choice \"" + 
      configuration.getOutputManagerType() + "\" encountered.";
    mySimulationManager->shutdown( error );
  }
  
  return retval;
}

const OutputManagerFactory *
OutputManagerFactory::instance(){
  static OutputManagerFactory *singleton = new OutputManagerFactory();
  return singleton;
}
