#ifndef CONFIGURATION_MANAGER_FACTORY_H
#define CONFIGURATION_MANAGER_FACTORY_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Configurer.h"
class Application;

/** Creates ConfigurationManagers

*/
class ConfigurationManagerFactory : virtual public Configurer {
public:
  static const ConfigurationManagerFactory *instance();

  /**
     Allocates a ConfigurationManager based on the current configuration.
     
     @param configuration The configuration used to determine what to build.

     @param parent This should be a handle to the application that we're getting
     ready to start.
   */
  Configurable *allocate( SimulationConfiguration &configuration,
			  Configurable *parent ) const;

protected:
  
  /// Default destructor
  virtual ~ConfigurationManagerFactory(){};
  
private:
  /// Default constructor
  ConfigurationManagerFactory(){};

};
#endif
