/*-----------------------------------------------------------------------------
 *  FILE: Wallpapers.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Dialog derivation that implements Wallpaper Tray search tool.
 *
 *-----------------------------------------------------------------------------
 */

#ifndef _WALLPAPERS_GF_12062006
#define _WALLPAPERS_GF_12062006

#include <gconfmm/client.h>
#include <gconfmm/entry.h>
#include <glibmm/ustring.h>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/regex.hpp>
#include "LibNotify.hh"

namespace fs = boost::filesystem;

class Applet;

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Used to set wallpapers, select random wallpapers and more.

@author Gareth Foster
@date 12/06/2006
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class Wallpapers
{
public:
	// public class methods
	Wallpapers(Applet * _pApplet);
	virtual ~Wallpapers();

	bool SetRandom(bool _bImediate);
	bool SetRandomDelayed();

	Glib::ustring GetCurrent();
	bool DeleteCurrent();

	void AcceptChange();
	void RejectChange();
	void DeleteChange();

private:
	// private class methods
	std::size_t CountDirectoryEntries(fs::path _pathCurrent, std::size_t & _nFileCount);
	void GetDirectoryEntryAtIndex(fs::path _pathCurrent, std::size_t & _nFileIndex, Glib::ustring & _szFile);
	std::size_t CountStatics();
	std::string GetStaticAtIndex(std::size_t _nFileIndex);
	void RegenerateTimeout(guint _nCnxn, Gnome::Conf::Entry _gconfEntry);

protected:
	Glib::RefPtr<Gnome::Conf::Client>			m_pGconfClient;
	sigc::connection							m_sigcConnection;
	boost::regex								m_regexImageCheck;
	Applet *									m_pApplet;
	LibNotify									m_Notify;
	Glib::ustring								m_szFile;

};// end class Wallpapers

#endif	// _WALLPAPERS_GF_12062006
